#include <sys/timeb.h>
#include <time.h>
#include <complex>

using namespace std;

class GaussianTransform
{
public:
	GaussianTransform();
	~GaussianTransform();
	bool readData(char *fileName);
	void generateData(int minS, int maxS, int numS, int sigmaS, int sigmaW, int minT, int maxT, int numT, int sigmaT);
	void slow_gt();
	void trunc_gt(int size);
	void appr_gt(int Nterms);
	void fast_gt(int Nterms);
	void output_results();
	void startTimer();
	void stopTimer();
	void printTime();
protected:

private:
	double evaluateFourier(double x,int Nterms);
	double *sources, *weights, *targets, *results;
	double *Cp;
	double *coefficients;
	int Nsources, Ntargets;
	double delta;
	int L;
	struct _timeb start,stop;
};