﻿//Output mode that shows a picture of the ASL hand sign 
//associated with the potential letter.
//Created June 5, 2007
//Updated October 9, 2007

class ASL implements OutputMode, Observer {

	var iv:ImageViewer;
	var returned:String;
	var field:TextField;
	var myformat:TextFormat;
	var capital:Boolean = false;
	var myTarget:MovieClip;

	//Constructor
	public function ASL(target:MovieClip) {
		myTarget = target;
		iv = new ImageViewer(myTarget);
		iv.addObserver(this);
		returned = new String();
		
		if (Main.USER_FORMAT) {
			myformat = Main.myformat;
		} else {
			myformat = new TextFormat();
			myformat.color = 0xFFFF00;
			myformat.size = 20;
			myformat.align = "center";
		}
	}
	
	//Used if the symbol is not found in the ASL picture folder
	public function update(o:Observable, infoObj:Object) {
		if (infoObj != "") {
			var badPath:String = String(infoObj);
			var badFile:String = badPath.substring(4, badPath.length-1);
			var badSymbol:String = badFile.substring(0, badFile.length-3);
				if (!capital)			
				field.text = "The current symbol is '"+badSymbol+"'";
				else
				field.text = "The current symbol is '"+badSymbol.toUpperCase()+"'";
			
			if (badSymbol=="predict")
				field.text = "Use word prediction";

			field.setTextFormat(myformat);
		}
	}
	//Known issue: when run from a server, the ASL/?.JPG does not act correctly
	//Same for #.JPG and ;.JPG (sometimes)
	public function outputPotential(output:String, field:TextField) {
		myTarget._visible = true;
		if (output == "words")
			output = "predict";		
		var backup = output;
		output = output.toLowerCase();
		
		if ((Main.SPEECH)&&(Main.WORD_PREDICT)&&(output.length<=2))
			Sounds.playSound(output+".mp3");
			
		else if ((Main.SPEECH)&&((output=="ing")||(output=="the")||
				(output=="for")||(output=="with")||(output=="and")||
				(output=="abcde")||(output=="fghij")||(output=="klmno")||
				(output=="pqrst")||(output=="uvwxyz")||(output=="predict")||
				(output=="punct.")||(output=="special")||(output=="etaoi")||
				(output=="nsrhl")||(output=="ducmf")||(output=="pgwyb")||
				(output=="vkxjqz")||(output=="capital")||(output=="delete")||
				(output=="words")||(output=="cancel")))
			Sounds.playSound(output+".mp3");
			
		else if ((Main.WORD_PREDICT)&&(!Main.CUSTOM_SPEECH)&&(Main.SPEECH))
			Sounds.playURL("prediction/"+output+".mp3");
			
		else if (Main.CUSTOM_SPEECH)
			Sounds.playURL("custom/"+output+".mp3");
			
		else if (Main.SPEAK_EXAMPLES)
			Sounds.playURL("examples/"+output+".mp3");			
		
		else if (Main.SPEECH)
			Sounds.playSound(output+".mp3");
		output = backup;	
		this.field = field;
		field.text = "";
		
		if (output!=output.toLowerCase())
			capital = true;
		else
			capital = false;
		
		if ((output != "?")&&(output!="#")&&(output!=";")) {
			returned = iv.loadImage("ASL/"+output.toLowerCase()+".JPG");

			if (returned == "Error") {
				field.text = output;
				field.setTextFormat(myformat);
			}
		} else {
			myTarget._visible = false;
			update(null,"ASL/"+output+".JPG");
		}
	}
	
	//Displays the associated picture and adds the selected letter to the
	//output string.
	public function outputActual(output:String, field:TextField) {
		var backup = output;
		output = output.toLowerCase();
		if (Main.SPEECH) {
			Sounds.playSound(output+".mp3");
		}
		else if (Main.CUSTOM_SPEECH){
			Sounds.playURL("custom/"+output+".mp3");
		}
		output = backup;
		field.text = field.text+output;
	}
	
	//Adds the selected word to the output string
	public function outputWord(output:String, field:TextField){
		if (Main.SPEECH)
			Sounds.playURL("prediction/"+output+".mp3");
		else if (Main.CUSTOM_SPEECH)
			Sounds.playURL("custom/"+output+".mp3");
		else if (Main.SPEAK_EXAMPLES)
			Sounds.playURL("examples/"+output+".mp3");
			
		field.text = field.text.substring(0, field.text.lastIndexOf(" ")+1)
 					+ output+" ";
	}	
}