﻿//This class contains tools for allowing custom lists to be parsed
//Created Sept. 5, 2007
//Updated Sept. 11, 2007

class CustomList{
	
	static var customList:Array;
	
	static function parseString(input:String){
		customList=new Array();
		input=input.toLowerCase();
		customList = input.split(",");
		fixSpaces();
	}
	
	private static function fixSpaces(){
		for (var i=0; i<customList.length; i++)
			customList[i] = trim(customList[i]);
	}
	
	private static function isWhitespace(char:String):Boolean
	{
		return ((char == " ")||(char.charCodeAt(0) == 9)||(char.charCodeAt(0)==10));
	} 

	private static function ltrim(str:String):String
	{
		if (str.length <= 0)
			return "";
		else if (!isWhitespace(str.charAt(0)))
			return str;
		else
			return ltrim(str.substring(1));
	} 

	private static function rtrim(str:String):String
	{
		if (str.length <= 0)
			return "";
		else if (!isWhitespace(str.charAt(str.length - 1)))
			return str;
		else
			return rtrim(str.substring(0, str.length - 1));
	}

	private static function trim(str:String):String
	{ 
		return (str.length == 0 ? "" : ltrim(rtrim(str))); 
	}
}
