﻿/*This is an input class that starts scrolling through the letters at the press
of a button and selects a letter at the press of that button.*/
//Created June 3, 2007
//Updated July 25, 2007

class Cycle implements Observer, InputMode{

	private var output:String = "";			//Output to the text field
	private var kl:KeyListener;				//KeyListener object
	private var ml:MouseListener;
	private var os:ObservableSubject;		//Allows JustKeyboard to be observed
	public static var characters:Array = [" ","a","b","c","d","e","f","g","h","i","j","k",
									"l","m","n","o","p","q","r","s","t","u","v",
									"w","x","y","z","0","1","2","3","4","5","6",
									"7","8","9",".",",","?","!","\"","'",
									"capital","delete"];
	public static var ARR_LENGTH = 45;
	private var i:Number = -1;
	private var capital:Boolean = false;
	private var timeObj:Time;
	private var cycling:Boolean = false;
	public static var SWITCH_TIME:Number = 800;
	private var lastSwitch:Number = -SWITCH_TIME;
	static var extraTime:Number = 0;
	static var mySound:Sound;

	//Constructor
	public function Cycle() {
		mySound = new Sound();
		os = new ObservableSubject();
		timeObj = Time.getInstance();
		timeObj.addObserver(this);
		notifyObservers("Clear output");
		kl = KeyListener.getInstance();
		kl.addObserver(this);
		ml = MouseListener.getInstance();
		ml.addObserver(this);
	}
	
	//Update this object by listening to other objects
	public function update(o:Observable, infoObj:Object) {
		if ((infoObj == "Key Pressed")||(infoObj == "Mouse Pressed")||(infoObj == "Right Click")) {
			keyPressed();
		}
		else if (infoObj == "Key Released"){
			//NOTHING
		}else{
			checkTime(Number(infoObj));
		}
	}
	
	//Helper function that checks the time
	private function checkTime(currentTime:Number){
		if ((currentTime >= (lastSwitch+SWITCH_TIME+extraTime))&&(cycling)){
			i++;
			setChanged();
				if (!capital){
				output = characters[i%characters.length];
				//nextOutput = characters[(i+1)%characters.length];
				}else{
				output = characters[i%characters.length].toUpperCase();
				//nextOutput = characters[(i+1)%characters.length].toUpperCase();
				}
			fixExtraTime();
			notifyObservers("Potential Letter");
			lastSwitch = currentTime;
		}
	}
	
	//Defines action on a keypress
	public function keyPressed() {
		if (!cycling){
			cycling = true;
		}
		
		else if (cycling){
			setChanged();
			if (characters[i%characters.length] == "delete"){
				notifyObservers("Backspace");
				capital = false;
			}
			else if (characters[i%characters.length] == "capital"){
				capital = true;
				output = "";
				notifyObservers("Selected Letter");
			}
			else if (characters[i%characters.length] != undefined){
				output = characters[i%characters.length];
				//nextOutput = characters[(i+1)%characters.length];
				fixExtraTime();
					if (capital)
					output = output.toUpperCase();
				notifyObservers("Selected Letter");
				capital = false;
			}
			else {
				output = "";
				notifyObservers("Selected Letter");
			}
			cycling = false;
			i = -1;
			lastSwitch = 0;
		}
	}
	
	//Getter for other objects
	public function getNewOutput():String{
		return output;
	}
	
	//Adds the duration of the associated sound file to the selected switch time
	//This prevents overlap.
	public function fixExtraTime(){
		mySound = new Sound();
		if ((Main.WORD_PREDICT)&&(WordList.wholeWord(output.toLowerCase()))){
			mySound.onLoad = setExtraTime;
			mySound.loadSound("prediction/"+output.toLowerCase()+".mp3",true);
			mySound.stop("prediction/"+output.toLowerCase()+".mp3");
		}
		if (Main.SPEECH){
			mySound.attachSound(output.toLowerCase()+".mp3");
				if ((mySound.duration!=undefined)&&(mySound.duration!=0))
				extraTime = mySound.duration;
		}
		else if (Main.CUSTOM_SPEECH){
			mySound.onLoad = setExtraTime;					
			mySound.loadSound("custom/"+output.toLowerCase()+".mp3",false);
			mySound.stop("custom/"+output.toLowerCase()+".mp3");
		}
		else if (Main.SPEAK_EXAMPLES){
			mySound.onLoad = setExtraTime;					
			mySound.loadSound("examples/"+output.toLowerCase()+".mp3",false);
			mySound.stop("exampls/"+output.toLowerCase()+".mp3");
		}
		
	}

	//Helper for above function
	private function setExtraTime() {
			if ((mySound.duration!=undefined)&&(mySound.duration!=0))
			extraTime = mySound.duration;
			else
			extraTime = 0;
	}
	
//-------------------------------------------------------------------
	//Allows Cycle to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
	

}