﻿/*This is an input class that starts scrolling through the letters at the press
of a button and selects a letter at the press of that button.
It uses groupings of letters to arrive at the destination symbol faster.*/
//Created June 17, 2007
//Updated October 10, 2007

class CycleGroup implements Observer, InputMode {

	private var output:String = "";//Output to the text field
	private var kl:KeyListener;//KeyListener object
	private var ml:MouseListener;
	private var os:ObservableSubject;//Allows JustKeyboard to be observed
	public static var characters:Array = [[" ","a","b","c","d","e","CANCEL"],
										[" ","f","g","h","i","j","CANCEL"],
										[" ","k","l","m","n","o","CANCEL"],
										[" ","p","q","r","s","t","CANCEL"],
										[" ","u","v","w","x","y","z","CANCEL"],
										[" ","0","1","2","3","4","5","6","7","8","9","CANCEL"],
										[" ",".",",","?","!","\"","'","CANCEL"],
										[" ","capital","delete","CANCEL"]];
	public static var ARR_LENGTH = 8;
	public static var myLabels:Array = ["abcde","fghij","klmno","pqrst","uvwxyz",
									  "#","punct.", "special"];
	private var group:Array;
	private var inGroup:Boolean = false;
	private var i:Number = -1;
	private var capital:Boolean = false;
	private var timeObj:Time;
	private var cycling:Boolean = false;
	public static var SWITCH_TIME:Number = 800;
	private var lastSwitch:Number = -SWITCH_TIME;
	static var extraTime:Number = 0;
	static var mySound:Sound;

	//Constructor
	public function CycleGroup() {
		mySound = new Sound();
		os = new ObservableSubject();
		timeObj = Time.getInstance();
		timeObj.addObserver(this);
		notifyObservers("Clear output");
		kl = KeyListener.getInstance();
		kl.addObserver(this);
		ml = MouseListener.getInstance();
		ml.addObserver(this);
	}
	
	//Update this object by listening to other objects
	public function update(o:Observable, infoObj:Object) {
		if ((infoObj == "Key Pressed") || (infoObj == "Mouse Pressed") || (infoObj == "Right Click")) {
			keyPressed();
		} else if (infoObj == "Key Released") {
			//NOTHING
		} else {
			checkTime(Number(infoObj));
		}
	}
	
	//Helper function that checks the time
	private function checkTime(currentTime:Number) {
		if ((currentTime >= (lastSwitch+SWITCH_TIME+extraTime))&&(cycling)){
			i++;
			setChanged();
			if (inGroup) {
				if (!capital) {
					output = group[i%group.length];
				} else {
					output = group[i%group.length].toUpperCase();
				}
			} else {
				if (!capital) {
					output = myLabels[i%myLabels.length];
				} else {
					output = myLabels[i%myLabels.length].toUpperCase();
				}
			}
			fixExtraTime();
			notifyObservers("Potential Letter");
			lastSwitch = currentTime;
		}
	}
	
	//Defines action on a key press
	public function keyPressed() {
		if (!cycling) {
			cycling = true;
		} 
		else if (cycling) {
			if (!inGroup) {
				inGroup = true;
				group = characters[i%characters.length];
				i = -1;
				lastSwitch = 0;
			} 
			else {
				setChanged();
				if (group[i%group.length] == "delete") {
					notifyObservers("Backspace");
					capital = false;
				} 
				else if (group[i%group.length] == "capital") {
					capital = true;
					output = "";
					notifyObservers("Selected Letter");
				} 
				else if (group[i%group.length].toLowerCase() == "cancel"){
					output = "";
					notifyObservers("Selected Letter");
				}
				else if (group[i%group.length] != undefined) {
					output = group[i%group.length];
					//nextOutput = group[(i+1)%group.length];
					if (capital) {
						output = output.toUpperCase();
					}
					notifyObservers("Selected Letter");
					capital = false;
				} 
				else {
					output = "";
					notifyObservers("Selected Letter");
				}
				fixExtraTime();					
				cycling = false;
				i = -1;
				inGroup = false;
				lastSwitch = 0;
			}
		}
	}
	
	//Getter for other objects
	public function getNewOutput():String {
		return output;
	}
	
	//Adds the duration of the associated sound file to the selected switch time
	//This prevents overlap.
	public function fixExtraTime(){
		mySound = new Sound();
		if ((Main.WORD_PREDICT)&&(WordList.wholeWord(output.toLowerCase()))){
			mySound.onLoad = setExtraTime;
			mySound.loadSound("prediction/"+output.toLowerCase()+".mp3",true);
			mySound.stop("prediction/"+output.toLowerCase()+".mp3");
		}
		if (Main.SPEECH){
			mySound.attachSound(output.toLowerCase()+".mp3");
				if ((mySound.duration!=undefined)&&(mySound.duration!=0))
				extraTime = mySound.duration;
		}
		else if (Main.CUSTOM_SPEECH){
			mySound.onLoad = setExtraTime;					
			mySound.loadSound("custom/"+output.toLowerCase()+".mp3",false);
			mySound.stop("custom/"+output.toLowerCase()+".mp3");
		}
		else if (Main.SPEAK_EXAMPLES){
			mySound.onLoad = setExtraTime;					
			mySound.loadSound("examples/"+output.toLowerCase()+".mp3",false);
			mySound.stop("exampls/"+output.toLowerCase()+".mp3");
		}
	}
	
	//Helper for above function
	private function setExtraTime() {
			if ((mySound.duration!=undefined)&&(mySound.duration!=0))
			extraTime = mySound.duration;
			else
			extraTime = 0;
	}
	
	//-------------------------------------------------------------------
	//Allows CycleGroup to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
}