﻿//Class for viewing images
//Created June 5, 2007
//Updated July 25, 2007

class ImageViewer {
  
  private var mc:MovieClip;
  private var loader:MovieClipLoader;
  private var canConnect:Boolean;
  private var errorString:String = "Error";
  private var os:ObservableSubject;
  private var path:String;
  
  //Constructor
  public function ImageViewer (target:MovieClip) {
    mc = target;
	os = new ObservableSubject();
	loader = new MovieClipLoader();
  	loader.addListener(this);
  }
  
  //Notifies observers if there is an error
  public function onLoadError(){
	  setChanged();
	  notifyObservers(path);
  }
  
  //Notifies observers when the load is complete
  public function onLoadComplete(){
	  setChanged();
	  notifyObservers("");
  }

  //Displays the picture pointed to by the given path
  public function loadImage (path:String):String {
	mc._visible = true;
	this.path = path;
	canConnect = loader.loadClip(path, mc);
	if (!canConnect){
		return (errorString);
		}
	}
  
  public function hideImage (){
	  mc._visible = false;
  }
  
 //-------------------------------------------------------------------
	//Allows ImageViewer to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	} 
  
}