﻿/*This is an input class that simply reads input from the keyboard.*/
//Created May 27, 2007
//Updated August 28, 2007

class JustKeyboard implements Observer, InputMode{

	private var output:String = "";			//Output to the text field
	private var kl:KeyListener;				//KeyListener object
	private var os:ObservableSubject;		//Allows JustKeyboard to be observed
	private var AsciiTable:Array;
	private var ShiftTable:Array;
	private var shift:Boolean = false;
	private var shiftReleased:Boolean = true;

	//Constructor
	public function JustKeyboard() {
		os = new ObservableSubject();
		notifyObservers("Clear output");
		defineArrays();
		
		kl = KeyListener.getInstance();
		kl.addObserver(this);
	}
	
	//Update this object by listening to other objects
	public function update(o:Observable, infoObj:Object) {
		if (infoObj == "Key Pressed") {
			//if ((!((kl.getKey()<=40)&&(kl.getKey>=37)))||(kl.getKey()==16))
			if ((kl.getKey()<37)||(kl.getKey()>40))
			keyPressed();
		} else if (infoObj == "Key Released") {
			//if ((!((kl.getKey()<=40)&&(kl.getKey>=37)))||(kl.getKey()==16))
			if ((kl.getKey()<37)||(kl.getKey()>40))
			keyReleased();
		}
	}
	
	//Take action on a keypress
	public function keyPressed() {
		var ASCII:Number = kl.getKey();
		if (AsciiTable[ASCII]!=undefined){
			ASCII=AsciiTable[ASCII];
		}
		if ((KeyListener.m)&&(ASCII==45))
			ASCII = 109;	
		
		if ((ASCII != 8)&&(ASCII!=14)){
			var char:String = String.fromCharCode(ASCII);
			setChanged();
			output = char;
			//output = output.toLowerCase();
				if ((shift)&&(ShiftTable[output]!=undefined))
				output = ShiftTable[output];	
			notifyObservers("Potential Letter");
		}
		
		else if (ASCII == 14){
			shiftReleased=false;
			shift = true;
		}
		
		else if ((ASCII==8)||(ASCII!=46)){
			setChanged();
			notifyObservers("Backspace");
		}
	}
	
	//Take action on keyrelease
	public function keyReleased() {
		var ASCII:Number = kl.getKey();
		if (AsciiTable[ASCII]!=undefined)
			ASCII=AsciiTable[ASCII];
		
		if ((KeyListener.m)&&(ASCII==45))
			ASCII = 109;
			
		if ((ASCII != 8)&&(ASCII!=14)){
			var char:String = String.fromCharCode(ASCII);
			setChanged();
			output = char;
			//output = output.toLowerCase();
				if ((shift)&&(ShiftTable[output]!=undefined))
				output = ShiftTable[output];
				if (shiftReleased)
				shift = false;
			notifyObservers("Selected Letter");
		}
		else if (ASCII==14){
		shiftReleased = true;
		shift=false;
		}
	}
	
	//Getter
	public function getNewOutput():String{
		return output;
	}
	
	public function defineArrays(){
		AsciiTable = new Array();
		AsciiTable[186]=59;			//;
		AsciiTable[222]=39;			//'
		AsciiTable[191]=47;			///
		AsciiTable[188]=44;			//,
		AsciiTable[190]=46;			//.
		AsciiTable[219]=91;			//[
		AsciiTable[221]=93;			//]
		AsciiTable[109]=45;			//-
		AsciiTable[192]=96;			//`
		AsciiTable[220]=92;			//\
		AsciiTable[16]=14;			//Shift
		AsciiTable[46]=8;			//Delete
		
		ShiftTable = new Array();
		ShiftTable["a"]="A";		//Letters
		ShiftTable["b"]="B";
		ShiftTable["c"]="C";
		ShiftTable["d"]="D";
		ShiftTable["e"]="E";
		ShiftTable["f"]="F";
		ShiftTable["g"]="G";
		ShiftTable["h"]="H";
		ShiftTable["i"]="I";
		ShiftTable["j"]="J";
		ShiftTable["k"]="K";
		ShiftTable["l"]="L";
		ShiftTable["m"]="M";
		ShiftTable["n"]="N";
		ShiftTable["o"]="O";
		ShiftTable["p"]="P";
		ShiftTable["q"]="Q";
		ShiftTable["r"]="R";
		ShiftTable["s"]="S";
		ShiftTable["t"]="T";
		ShiftTable["u"]="U";
		ShiftTable["v"]="V";
		ShiftTable["w"]="W";
		ShiftTable["x"]="X";
		ShiftTable["y"]="Y";
		ShiftTable["z"]="Z";
		ShiftTable["1"]="!";		//Numbers		
		ShiftTable["2"]="@";
		ShiftTable["3"]="#";
		ShiftTable["4"]="$";
		ShiftTable["5"]="%";
		ShiftTable["6"]="^";
		ShiftTable["7"]="&";
		ShiftTable["8"]="*";
		ShiftTable["9"]="(";
		ShiftTable["0"]=")";
		ShiftTable["`"]="~";		//Punctuation
		ShiftTable["-"]="_";
		ShiftTable["="]="+";
		ShiftTable[";"]=":";
		ShiftTable["'"]="\"";
		ShiftTable[","]="<";
		ShiftTable["."]=">";
		ShiftTable["/"]="?";
		ShiftTable["\\"]="|";
		ShiftTable["["]="{";
		ShiftTable["]"]="}";
		}
	
//-------------------------------------------------------------------
	//Allows JustKeyboard to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
	

}