﻿//KeyListener class
//Singleton, only one instance of this class is required to send values to all
//observing classes
//Created May 22, 2007
//Updated June 15, 2007
import flash.external.*;

class KeyListener {

	//Character obtained by listening to the Keyboard
	private var keyASCII:Number = new Number();
	//Allows other objects to observe this object
	private var os:ObservableSubject;
	private static var instance:KeyListener;
	public static var m:Boolean = false;
	
	//Allows other classes to get an instance of this class
	public static function getInstance(){
		if (instance==undefined)
		instance = new KeyListener();
	return instance;
	}
	
	//Constructor
	private function KeyListener() {
		os = new ObservableSubject();
		//Key.addListener(this);//Sets itself up as a listener to keys
	}

	//Define action on key press
	public function onKeyDown(code:Number) {
		setChanged();
			if (code==undefined){
			keyASCII = Key.getAscii();
			}
			
			else if (code>=0){
			keyASCII = code;
				if ((code>=65)&&(code<=90)){
				keyASCII = code+32;
				}
				if ((keyASCII==109)&&(code==77))
				m=true;
				else if ((keyASCII==109)&&(code==109))
				m=false;
			}
		notifyObservers(new String("Key Pressed"));
	}
	
	//Define action on key release
	public function onKeyUp(code:Number) {
		setChanged();
			if (code==undefined){
			keyASCII = Key.getAscii();
			}
			
			else if (code>=0){
			keyASCII = code;
				if ((code>=65)&&(code<=90)){
				keyASCII = code+32;
				}
			}
		notifyObservers(new String("Key Released"));
	}
	
	//Get the ASCII value of the key that was pressed or released
	public function getKey():Number {
		return keyASCII;
	}
		
//-------------------------------------------------------------------
	//Allows KeyListener to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
}