﻿//Main class that creates and observes the objects and updates the
//output text fields accordingly
//Created May 25, 2007
//Updated November 13, 2007

class Main implements Observer {

	private var inputObj:InputMode;//Input object with which to interact
	private var inputChoice:String;
	private var outputChoice:String;
	private var outputObj:OutputMode;
	private var field:TextField;//Text field in which to output results
	private var potentialField:TextField;//Text field
	private var output:String = "";//Output to the text field
	private var backup:String = "";//Backup string, holds output
	private var modified:Boolean = false;
	private var kl:KeyListener;
	private var key:Number;
	private var index:Number = -1;
	private var matchingWords:Array;
	private var predicting:Boolean = false;
	private var dirtyField:Boolean = false;
	private var timeObj:Time;
	private var lastPotential:Number = 0;
	private var space = false;

	public static var myformat:TextFormat;
	public static var SPEECH:Boolean;
	public static var USER_FORMAT:Boolean = false;
	public static var SIZE_MODIFIED:Boolean = false;
	public static var CUSTOM_SPEECH:Boolean = false;
	public static var SPEAK_EXAMPLES:Boolean = false;
	public static var WORD_PREDICT:Boolean = false;
	public static var OFFSET:Number = 1000;

	//Constructor
	public function Main(field:TextField, inputChoice:String, outputChoice:String, speech:Boolean, container:MovieClip, format:TextFormat, potentialField:TextField) {
		backup = "";
		output = "";
		SPEECH = speech;
		kl = KeyListener.getInstance();
		kl.addObserver(this);
		timeObj = Time.getInstance();
		this.inputChoice = inputChoice;
		this.outputChoice = outputChoice;

		if ((format.size == undefined) && (format.color == undefined)) {
			myformat = new TextFormat();
			myformat.color = 0xFFFF00;
			myformat.size = 20;
			myformat.align = "center";
			SIZE_MODIFIED = false;
		} else {
			myformat = new TextFormat();
			myformat.size = format.size;
			myformat.color = format.color;
			SIZE_MODIFIED = true;
			if (myformat.size == undefined) {
				myformat.size = 20;
				SIZE_MODIFIED = false;
			}
			if (myformat.color == undefined) {
				myformat.color = 0xFFFF00;
			}
			USER_FORMAT = true;
		}
		this.field = field;
		this.potentialField = potentialField;

		if (inputChoice == "Braille") {
			inputObj = new Braille();
		} else if (inputChoice == "Keyboard") {
			inputObj = new JustKeyboard();
		} else if (inputChoice == "ScrollAndClick") {
			inputObj = new ScrollAndClick();
		} else if (inputChoice == "Cycle") {
			inputObj = new Cycle();
		} else if (inputChoice == "CycleGroup") {
			inputObj = new CycleGroup();
		} else if (inputChoice == "ScrollGroup") {
			inputObj = new ScrollGroup();
		}
		inputObj.addObserver(this);

		if (outputChoice == "Text") {
			outputObj = new SpeakAndText();
		} else if (outputChoice == "BigText") {
			outputObj = new SpeakAndBigText();
		} else if (outputChoice == "ASL") {
			outputObj = new ASL(container);
		} else if (outputChoice == "CustomPix") {
			outputObj = new CustomPix(container);

		}
	}
	
	//Update the text field based on observation of Input object
	function update(o:Observable, infoObj:Object) {

		if (infoObj == "Key Pressed") {
			if (((inputChoice=="Braille")||(inputChoice=="Keyboard"))&&
			   ((kl.getKey()>=37) && (kl.getKey()<=40))) {
				key = kl.getKey();
				if (WORD_PREDICT) {
					updateWord();
				}
			}
		} 
		
		else if (infoObj == "Key Released") {} 
		
		//Potential Letter, Selected Letter, Backspace, Message, Clear output
		else {
			if (dirtyField){
				dirtyField = false;
				field.text = backup;
			}
			field.setTextFormat(myformat);
			
			if (!modified) {
				modified = true;
				field.text = "";
			}
			if (infoObj == "Potential Letter") {
				if ((inputChoice == "Braille")||(inputChoice == "Keyboard"))
					lastPotential = timeObj.getCurrentTime();
				else
					lastPotential = -OFFSET;
				outputObj.outputPotential(inputObj.getNewOutput(),potentialField);
				predicting = false;
				index = -1;
			} 
			else if (infoObj == "Selected Letter") {
				if (field.text.charAt(field.text.length-1)=="_")
					field.text = field.text.slice(0, field.text.length-1)+" ";
					
				var backup1 = SPEECH;
				var backup2 = CUSTOM_SPEECH;
				var backup3 = SPEAK_EXAMPLES;
				var word:String = inputObj.getNewOutput();
				
				if ((timeObj.getCurrentTime()< (lastPotential+OFFSET))){
					SPEECH = false;
					CUSTOM_SPEECH = false;
					SPEAK_EXAMPLES = false;
				}
				if ((word.length > 2)&&
					(word.toLowerCase()!="ing")&&
					(word.toLowerCase()!="the")&&
					(word.toLowerCase()!="for")&&
					(word.toLowerCase()!="with")&&
					(word.toLowerCase()!="and"))
					outputObj.outputWord(word,field);
				else{
						if (word==" "){
							word = "_";
							space = true;
						}
					outputObj.outputActual(word,field);
				}
				SPEECH = backup1;
				CUSTOM_SPEECH = backup2;
				SPEAK_EXAMPLES = backup3;
				resetTextFormat();
				if ((WORD_PREDICT) && (field.text.length>=1)) {
					predict();
					updateList();
				}
			} 
			else if (infoObj == "Backspace") {
				field.text = field.text.slice(0, field.text.length-1);
				field.setTextFormat(myformat);
				potentialField.text = "";
				if ((WORD_PREDICT) && (field.text.length>=1)) {
					predict();
					updateList();
				}
				else if (field.text.length == 0)
					matchingWords = [];
			} 
			else if (infoObj == "Message") {
				backup = field.text;
				dirtyField = true;
				field.text = inputObj.getNewOutput();
				field.setTextFormat(myformat);
			} 
			else if (infoObj == "Clear output") {
				field.text = "";
				field.setTextFormat(myformat);
			}
		}
	}
	
	//Gets the array of matching words for the current string
	function predict():Void {
		var lastSpace:Number = field.text.lastIndexOf(" ");
		var word:String="";		
			if ((lastSpace != -1)&&(lastSpace!= field.text.length-1))
				word = field.text.substring(lastSpace+1,field.text.length);
			else
				word = field.text;
				
		if (WordList.inList(word)) {
			predicting = true;
			matchingWords = WordList.getMatching(word);
		}
		else
			matchingWords = [];
	}
	
	//Allows the user to scroll through or pick a word
	function updateWord():Void {
		if (key == 39) {		//Right Arrow
			if (predicting) {
				if (matchingWords[(index+1)%matchingWords.length] != undefined)
				outputObj.outputPotential(matchingWords[++index%matchingWords.length], potentialField);
			}
		} else if (key == 40) {	//down arrow
			if (predicting) {
				if (matchingWords[index%matchingWords.length] != undefined)
					outputObj.outputWord(matchingWords[index%matchingWords.length],field);
				index = -1;
				matchingWords = [];
				predicting = false;
				field.setTextFormat(myformat);
				updateList();
			}
		}
	}
	
	//For Cycle and ScrollAndClick, adds predicted words to front of list
	function updateList():Void{
		if ((inputChoice.toLowerCase()=="scrollandclick")||
			(inputChoice.toLowerCase()=="cycle")||
			(inputChoice.toLowerCase()=="scrollgroup")||
			(inputChoice.toLowerCase()=="cyclegroup")) {
		while (Cycle.characters.length!=Cycle.ARR_LENGTH)
			Cycle.characters.shift();
		while (CycleGroup.characters.length!=CycleGroup.ARR_LENGTH)
			CycleGroup.characters.shift();
		while (CycleGroup.myLabels.length!=CycleGroup.ARR_LENGTH)
			CycleGroup.myLabels.shift();
		
		Cycle.characters = matchingWords.concat(Cycle.characters);
		
		if (matchingWords.length!=0){
			matchingWords.push("CANCEL");
			var temp:Array = [matchingWords];
			CycleGroup.characters = temp.concat(CycleGroup.characters);
			temp = ["WORDS"];
			CycleGroup.myLabels = temp.concat(CycleGroup.myLabels);
		}
		
		ScrollAndClick.characters = Cycle.characters;
		ScrollGroup.characters = CycleGroup.characters;
		ScrollGroup.myLabels = CycleGroup.myLabels;
		}
	}
	
	
	function resetTextFormat() {
		field.setTextFormat(myformat);
	}
	
	//Stops listening to other objects
	function kill() {
		kl.removeObserver(this);
		inputObj.removeObserver(this);
	}
}