﻿//MouseListener class
//Singleton, only one instance of this class is required to send values to all
//observing classes
//Created June 4, 2007
//Updated June 15, 2007
import flash.external.*;

class MouseListener{

	//Allows other objects to observe this object
	private var os:ObservableSubject;
	private static var instance:MouseListener;

	public static function getInstance(){
		if (instance==undefined)
		instance = new MouseListener();
	return instance;
	}
	
	//Constructor
	private function MouseListener() {
		os = new ObservableSubject();
		//Mouse.addListener(this);//Sets itself up as a listener to the mouse
	}

	//Define action on key press
	public function onMouseDown(code:Number) {
		setChanged();
			if (code==undefined)
			code = 0;
		if (code==0)
		notifyObservers(new String("Mouse Pressed"));
		if (code==2)
		notifyObservers(new String("Right Click"));
	}	
	
//-------------------------------------------------------------------
	//Allows MouseListener to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
	
}