﻿//Implementation of Observable
//Allows an object to be observed by instantiating and manipulating 
//an ObservableSubject object in that object.
//Created May 25, 2007
//Updated May 25, 2007

class ObservableSubject implements Observable {
	
	private var changed:Boolean = false;
	private var observers:Array;

	//Constructor
	public function ObservableSubject() {
		observers = new Array();
	}
	
	//Add a new observer to the object
	public function addObserver(o:Observer):Boolean {
		if (o == null) {
			return false;
		}
		for (var i:Number = 0; i<observers.length; i++) {
			if (observers[i] == o) {
				return false;
			}
		}
		observers.push(o);
		return true;
	}
	
	//Remove an observer from the object
	public function removeObserver(o:Observer):Boolean {
		var len:Number = observers.length;
		for (var i:Number = 0; i<len; i++) {
			if (observers[i] == o) {
				observers.splice(i,1);
				return true;
			}
		}
		return false;
	}
	
	//Send a message to all the observers
	public function notifyObservers(infoObj:Object):Void {
		if (infoObj == undefined) {
			infoObj = null;
		}
		if (!changed) {
			return;
		}
		var observersSnapshot:Array = observers.slice(0);
		clearChanged();
		for (var i:Number = observersSnapshot.length-1; i>=0; i--) {
			observersSnapshot[i].update(this,infoObj);
		}
	}
	
	//Simple functions to manipulate ObservableSubject object
	public function clearObservers():Void {
		observers = new Array();
	}
	public function setChanged():Void {
		changed = true;
	}
	public function clearChanged():Void {
		changed = false;
	}
	public function hasChanged():Boolean {
		return changed;
	}
	public function countObservers():Number {
		return observers.length;
	}
}