﻿/*This is an input class that scrolls through the letters at the press
of a button and selects a letter at the press of another button.*/
//Created June 1, 2007
//Updated October 8, 2007

class ScrollAndClick implements Observer, InputMode{

	private var output:String = "";			//Output to the text field
	private var kl:KeyListener;				//KeyListener object
	private var ml:MouseListener;			//MouseListener object
	private var os:ObservableSubject;		//Allows JustKeyboard to be observed
	public static var scrollKey:String = "z";
	public static var chooseKey:String = "x";
	public static var characters:Array = [" ","a","b","c","d","e","f","g","h","i","j","k",
									"l","m","n","o","p","q","r","s","t","u","v",
									"w","x","y","z","0","1","2","3","4","5","6",
									"7","8","9",".",",","?","!","\"","'",
									"capital","delete"];
	private var i:Number = -1;
	private var capital:Boolean = false;
	private var AsciiTable:Array;

	
	//Constructor
	public function ScrollAndClick() {
		os = new ObservableSubject();
		notifyObservers("Clear output");
		kl = KeyListener.getInstance();
		kl.addObserver(this);
		ml = MouseListener.getInstance();
		ml.addObserver(this);
		
		AsciiTable = new Array();
		AsciiTable[186]=59;			//;
		AsciiTable[222]=39;			//'
		AsciiTable[191]=47;			///
		AsciiTable[188]=44;			//,
		AsciiTable[190]=46;			//.
		AsciiTable[219]=91;			//[
		AsciiTable[221]=93;			//]
		AsciiTable[109]=45;			//-
		AsciiTable[192]=96;			//`
		AsciiTable[220]=92;			//\
		AsciiTable[16]=14;			//Shift
		AsciiTable[46]=8;			//Delete
	}
	
	//Update the object as a result of listening to other objects
	public function update(o:Observable, infoObj:Object) {
		if (infoObj == "Key Pressed"){
			keyPressed(0);
		}
		else if (infoObj == "Mouse Pressed"){
			keyPressed(1000);
		}
		else if (infoObj == "Right Click"){
			keyPressed(1001);
		}
		
	}
	
	//Decide what to do on a keypress
	public function keyPressed(code:Number) {
		if (code==0){
			var ASCII:Number = kl.getKey();
			if (AsciiTable[ASCII]!=undefined)
				ASCII = AsciiTable[ASCII];
			var char:String = String.fromCharCode(ASCII);
			
			if (ASCII == 13)
				char = "enter";
			else if (ASCII == 14)
				char = "shift";
			else if (ASCII == 17)
				char = "ctrl";
			else if (ASCII == 32)
				char = "space";
			else if (ASCII == 37)
				char = "left";
			else if (ASCII == 38)
				char = "up";
			else if (ASCII == 39)
				char = "right";
			else if (ASCII == 40)
				char = "down";
		}

		if ((char == scrollKey)||(code==1000)){
			setChanged();
			output = characters[++i%characters.length];
				if (capital)
				output = output.toUpperCase();
			notifyObservers("Potential Letter");
		}
		else if ((char == chooseKey)||(code==1001)){
			setChanged();
			if (characters[i%characters.length] == "delete"){
				notifyObservers("Backspace");
				capital = false;
			}
			else if (characters[i%characters.length] == "capital"){
				capital = true;
				output = "";
				notifyObservers("Selected Letter");
			}
			else if (characters[i%characters.length] != undefined){
				output = characters[i%characters.length];
					if (capital)
					output = output.toUpperCase();
				notifyObservers("Selected Letter");
				capital = false;
			}
			else {
				output = "";
				notifyObservers("Selected Letter");
			}
			i = -1;
		}
	}
	
	//Getter for other objects
	public function getNewOutput():String{
		return output;
	}
	
//-------------------------------------------------------------------
	//Allows JustKeyboard to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
	

}