﻿//Represents a single key
//Observes the Time object in order to notify the Braille object
//when the SingleKey object should be removed
//Created May 28, 2007
//Updated May 29, 2007

class SingleKey implements Observer, Observable{
	
	public static var INTERVAL:Number = 1000;
	
	private var char:String = "";
	private var pressTime:Number = 0;
	private var releaseTime:Number = 0;
	
	private var now:Number = 0;
	private var os:ObservableSubject;
	private var time:Time;
	private var debug:Boolean = false;
	
	//Constructor
	public function SingleKey(charName:String){
		char = charName;
		releaseTime = Infinity;
		time = Time.getInstance();
		time.addObserver(this);
		pressTime = now = time.getCurrentTime();
		os = new ObservableSubject();
	}
	
	//Updates based on Time object
	public function update(o:Observable, infoObj:Object) {
		if (infoObj >= 0){				//Saves current time in ms
			now = Number(infoObj);
			checkTime();
		}
	}
	
	//Every time this object's time is updated, this method is called to
	//check if the SingleKey should be removed (key released >INTERVAL ms ago)
	public function checkTime() {
		if (now >= releaseTime + INTERVAL){
		setChanged();
		
		if (debug)
		trace("In SingleKey, release if possible '"+char+ "'.  Time = "
			  +now + ", ReleaseTime = "+releaseTime);
		
		notifyObservers("Remove this key"+char);
		time.removeObserver(this);
		clearObservers();
		releaseTime = Infinity;
		}
	}

//------------------------------------------------------------------------
	//Getters
	public function getCharName():String{
		return char;
	}
	public function getPressTime():Number{
		return pressTime;
	}
	public function getReleaseTime():Number{
		return releaseTime;
	}

	//Setter
	public function setReleaseTime(time:Number){
		if (time == undefined)
		releaseTime = now;
		else
		releaseTime = time;
	}
	
//---------------------------------------------------------------------
	//Allows SingleKey to be observed
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		os.notifyObservers(infoObj);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
	
	
}