﻿//Plays mp3 files in library and at URLs
//Created May 25, 2007
//Updated September 24, 2007

class Sounds {
	
	public static var musicVolume:Number = 100;
	public static var debugField:TextField;
	public static var prefix = "http://wwwx.cs.unc.edu/Research/assist/cgi-bin/speak.cgi?voice=female&say=";

	//Plays the sound corresponding with a given character
	static function playSound(path:String):Void {
		var sound:Sound = new Sound();
		sound.setVolume(100);
		try {
			path = path.toLowerCase();
			sound.attachSound(path);
			sound.start();
		} catch (e:Error) {
			trace("Sound error");
		}
	}
	
	//Plays a sound at a specific place on the server
	static function playURL(path:String):Void{
		var sound:Sound = new Sound();
		sound.setVolume(100);
		try {
			path = path.toLowerCase();
			sound.loadSound(prefix+path,false);
			sound.onLoad = function(){
				sound.start();
			}
		} catch (e:Error) {
			debugField.text += "Sound error";
		}
		//debugField.text += ">"+path+"<\n";
	}
	
	//Plays the background music
	static function playSong(path:String):Void{
		var sound:Sound = new Sound();
		sound.setVolume(musicVolume);
				
		sound.onLoad = function(){
			sound.start(0,1000);
			sound.setVolume(100);
		}
		sound.loadSound(path,false);
		sound.stop(path);
	}		
}