﻿//Implementation of output module that produces the sound associated
//with the value passed as a parameter and returns the string that should
//replace the current text field.
//Created May 31, 2007
//Updated October 9, 2007

class SpeakAndText implements OutputMode {

	var myField:TextField;
	var myformat:TextFormat;

	//Outputs the "current" letter so the user can decide whether he wants
	//to pick that letter or not
	public function outputPotential(output:String, field:TextField) {
		if (output == "words")
			output = "predict";
		var backup = output;
		output = output.toLowerCase();
		
		if ((Main.SPEECH)&&(Main.WORD_PREDICT)&&(output.length<=2))
			Sounds.playSound(output+".mp3");
			
		else if ((Main.SPEECH)&&((output=="ing")||(output=="the")||
				(output=="for")||(output=="with")||(output=="and")||
				(output=="abcde")||(output=="fghij")||(output=="klmno")||
				(output=="pqrst")||(output=="uvwxyz")||(output=="predict")||
				(output=="punct.")||(output=="special")||(output=="etaoi")||
				(output=="nsrhl")||(output=="ducmf")||(output=="pgwyb")||
				(output=="vkxjqz")||(output=="capital")||(output=="delete")||
				(output=="words")||(output=="cancel")))
			Sounds.playSound(output+".mp3");
			
		else if ((Main.WORD_PREDICT)&&(!Main.CUSTOM_SPEECH)&&(Main.SPEECH))
			Sounds.playURL("prediction/"+output+".mp3");
			
		else if (Main.CUSTOM_SPEECH)
			Sounds.playURL("custom/"+output+".mp3");
			
		else if (Main.SPEAK_EXAMPLES){
			Sounds.playURL("examples/"+output+".mp3");			
		}
		
		else if (Main.SPEECH)
			Sounds.playSound(output+".mp3");
		
		output = backup;	
		myField = field;
		
		if (Main.USER_FORMAT) {
			myformat = Main.myformat;
		} else {
			myformat = new TextFormat();
			myformat.color = 0xFFFF00;
			myformat.size = 20;
			myformat.align = "center";
		}
		if (output=="predict")
			myField.text = "Use word prediction";
		else
			myField.text = "The current symbol is '"+output+"'";
		
		myField.setTextFormat(myformat);
	}
	
	//Picks the letter and adds it to the output string
	public function outputActual(output:String, field:TextField) {
		var backup = output;
		output = output.toLowerCase();
		if (Main.SPEECH) {
			Sounds.playSound(output+".mp3");
		}
		else if (Main.CUSTOM_SPEECH){
			Sounds.playURL("custom/"+output+".mp3");
		}
		else if (Main.SPEAK_EXAMPLES)
			Sounds.playURL("examples/"+output+".mp3");		
		output = backup;
		myField = field;
		myField.text = myField.text+output;
	}
	
	//Adds an entire word to the output string
	public function outputWord(output:String, field:TextField){
		if (Main.SPEECH)
			Sounds.playURL("prediction/"+output+".mp3");
		else if (Main.CUSTOM_SPEECH)
			Sounds.playURL("custom/"+output+".mp3");		
		field.text = field.text.substring(0, field.text.lastIndexOf(" ")+1)
 					+ output+" ";
	}	
	
}