﻿//This sets up the table view for the one and two switch input modes
//This class takes the place of the Main class for this view
//Created July 20, 2007
//Updated July 25, 2007

class Table implements Observer{
	
	public static var HORIZONTAL_SHIFT = 57;
	public static var VERTICAL_SHIFT = 34;
	
	var tableField:TextField;
	var box:MovieClip;
	var outputField:TextField;
	var picture:MovieClip;
	var debug:TextField;
	var inputChoice:String;
	var inputObj:InputMode;
	var counter:Number = 0;
	var speech:Boolean = false;
	var outputChoice:String;
	var outputObj:OutputMode;
	var userFormat:TextFormat;
	
	//Constructor
	function Table(tableField:TextField, box:MovieClip, outputField:TextField,
				   picture:MovieClip, debug:TextField, inputChoice:String,
				   outputChoice:String, userFormat:TextFormat){
		
		//Populates table of symbols
		this.tableField = tableField;
		tableField.text = "";
		for (var i = 0; i<Cycle.characters.length; i++){
				if ((i == 11)||(i == 22)||(i==33))
					tableField.text+="\n";
			
				if (Cycle.characters[i]==" ")
					tableField.text+= "_  ";
				else if (Cycle.characters[i]=="capital")
					tableField.text+="^  ";
				else if (Cycle.characters[i]=="delete")
					tableField.text+="<  ";
				else		
					tableField.text+= Cycle.characters[i]+"  ";
		}
		var format = new TextFormat();
		format.bold=true;
		tableField.setTextFormat(format);
		
		this.userFormat = userFormat;
		var tempFormat = new TextFormat();
		tempFormat.color = userFormat.color;
		tableField.setTextFormat(tempFormat);
		
		this.outputField = outputField;
		
		this.box = box;
		box._visible = true;
		box._x = 8 - HORIZONTAL_SHIFT;
		box._y = 21;
		
		this.debug = debug;
		
		this.inputChoice = inputChoice;
		if (inputChoice == "Cycle")
			inputObj = new Cycle();
		else
			inputObj = new ScrollAndClick();
		inputObj.addObserver(this);
		
		this.outputChoice = outputChoice;
		if (outputChoice == "ASL")
			outputObj = new ASL(picture);
		else if (outputChoice == "CustomPix")
			outputObj = new CustomPix(picture);
		else
			outputObj = new ASL(null);
	}
	
	//Handles letter selections from the input module
	function update(o:Observable, infoObj:Object){
		if (infoObj == "Potential Letter"){
			if ((counter==11)||(counter==22)
				||(counter==33)||(counter==45)){
				box._x = 8;
				box._y = box._y + VERTICAL_SHIFT;
				
				if (counter == 45){
					box._x = 8;
					box._y = 21;
					counter = 0;
				}
			}
				
			else	
				box._x += HORIZONTAL_SHIFT;
			
			counter++;

			outputObj.outputPotential(inputObj.getNewOutput());	
		}
		
		else if (infoObj == "Selected Letter"){
			box._x = 8 - HORIZONTAL_SHIFT;
			box._y = 21;
			outputField.text += inputObj.getNewOutput();
			outputField.setTextFormat(userFormat);
			counter = 0;
			outputObj.outputPotential(inputObj.getNewOutput());	
			}
		
		else if (infoObj == "Backspace"){
			box._x = 8 - HORIZONTAL_SHIFT;
			box._y = 21;
			outputField.text=outputField.text.slice(0,outputField.text.length-1);
			outputField.setTextFormat(userFormat);
			counter = 0;
		}
	}
	
	//Called when the movie navigates away from the table view slide
	function kill(){
		inputObj.removeObserver(this);
	}
}