﻿//Singleton - only one copy is necessary
//Keeps track of time for the program
//Created May 28, 2007
//Updated July 25, 2007

class Time {

	public static var REFRESH:Number = 10;	//Update time every 10 ms

	private var os:ObservableSubject;
	private static var instance:Time;

	//Allows for global point of access for Time singleton
	public static function getInstance():Time{
		if (instance!=undefined)
			return instance;
		else{
			instance = new Time();
			return instance;
		}
	}
	
	//Private constructor
	private function Time() {
		os = new ObservableSubject();
		startTime();
	}

	//Starts the notification of the observers
	//Notifies observers every time (REFRESH) milliseconds pass
	public function startTime() {
		setInterval(this, "notifyObservers", REFRESH);
	}
	
	//Getter function for the current time
	public function getCurrentTime():Number{
		return  getTimer();
	}
	
	//--------------------------------------------------------------------
	//Allows Time to be listened to
	public function addObserver(o:Observer):Boolean {
		return os.addObserver(o);
	}
	public function removeObserver(o:Observer):Boolean {
		return os.removeObserver(o);
	}
	public function notifyObservers(infoObj:Object):Void {
		setChanged();
		var time:Number = getTimer();
		os.notifyObservers(time);
	}
	public function clearObservers():Void {
		os.clearObservers();
	}
	public function setChanged():Void {
		os.setChanged();
	}
	public function clearChanged():Void {
		os.clearChanged();
	}
	public function hasChanged():Boolean {
		return os.hasChanged();
	}
	public function countObservers():Number {
		return os.countObservers();
	}
}