﻿//This class is for predicting words by using a list of common words.
//Created June 19, 2007
//Updated October 9, 2007

class WordList{
	
	public static var list:Array = ["about","almost","another","around",
									"because","before","book","both","boy","but",
									"can","child","could","different","dog",
									"each","enough","every","face","family",
									"feet","food","girl","good","great","grow",
									"hand","head","hear","her","him","house",
									"idea","important", "just","keep","know",
									"land","large","last","learn","left","life",
									"like","little","long","look","made","man",
									"many","mean","might","mile","mother","move",
									"name","need","never","night","often","once",
									"only","open","other","page","paper","pencil",
									"people","picture","place","play","read",
									"right","said","same","school","seem",
									"sentence","should","show","small","song",
									"story","take","talk","tell","their","there",
									"they","thing","this","time","tree","under",
									"until","very","walk","want","water","went",
									"word","work","year","young"];
	
	//Returns true if the given string is a substring of at least
	//one word in the list.
	public static function inList(word:String):Boolean{
		for (var i = 0; i<list.length; i++){
			if (match(word,i))
			return true;
		}
	return false;	
	}

	//Returns an array of all the words that have the given string
	//as a substring
	public static function getMatching(word:String):Array{
	var toReturn:Array = new Array();	
		for (var i = 0; i<list.length; i++){
			if (match(word,i))
			toReturn.push(list[i]);
		}
	return toReturn;	
	}
	
	//Helper function to determine if the given string is a substring
	//of a specific word in the list (index specified by "i")
	private static function match(word:String,i:Number):Boolean{
		var len:Number = word.length;
		
		if (len!=list[i].length){
			var subst:String = list[i].substring(0,len);
				if (subst == word.toLowerCase())
				return true;
		}
		
		return false;
	}
	
	//Returns true if the given string is an exact match for a word
	//in the list
	public static function wholeWord(word:String):Boolean{
		for (var i = 0; i<list.length; i++){
			if (word==list[i])
			return true;
		}
	return false;	
	}	
}