# Written by Suzanne on 04/03/2003

# To load this module the first time, enter the following:
#       from pythonTest import *
# To load this module subsequent times, enter the following:
#       reload(pythonTest)
#       from pythonTest import *

# Useful Python commands
# - dir([module]) - list functions and other names this module contains
#     (either defined or as imports)
# - help([module]) or help([function]) - list help on function(s)
#     this module defines

#C:\Python22\python\ET_Project\python\docSkimmer

from speech import *   # for utility functions
from pySound3D import * # for spatial sound
from pyOpenAL import * # for spatial sound
from pyTTS import *    # for text-to-speech
import string
from string import *
import os, sys, time   # for system utils (not sure what these are for Windows)
from Tkinter import *  # for GUIs (used only as a test, _not_ for our system!)
#from Numarray import * # for 2d arrays
from time import sleep
import thread
import math

class Hierarchy(TTW3d):
	def __init__(self, txtFile=''):
		
		self.doc = []         # Document of words, without spaces.
		
		self.numWordsPerLine = 20 # Number of words per line of the file
		
		self.cursorPos0 = 0    # Current position of the cursor within level 0
		
		self.cursorPosN = 0    # Current position of the cursor within the 		 
		                       # current level
		
		#-----------------------------------------------------------------------
		# Variables for hierarchy of constant segment sizes for each level
		#
		self.segSize = -1      # Current size of segments
		
		self.subsegSize = -1   # Current size of subsegments:
		                       #  0 <= subsegSize <= segSize <= len(self.doc)-1
		                       
		self.numLevels = 1     # Current max number of levels:
		                       #  numLevels == floor(log2(len(doc)/segSize))+1
		                       # Level 0 is the highest resolution, the full document. Each subsequent level is a lower resolution, the 1st subsegment of each (levelNum+1) number of segments. i.e., As levelNum increases, fewer subsegments are read.
		                       
		self.level = 0         # Current level:
		                       #  0 <= level <= numLevels
		                       
		self.levels = [[]]     # List of lists of strings for the levels:
		                       #  len(levels) == numLevels and
		                       # Ai:0<=i<=numLevels-1:len(levels[i])==subsegSize
		                       
		#-----------------------------------------------------------------------
		TTW3d.__init__(self, txtFile) # Calls setTXTFile
		
	def setTXTFile(self, txtFile):
		""" Store the contents of a text file as a list of words, without delimiters or spaces. """
		TTW3d.setTXTFile(self, txtFile)
		if (txtFile != ''):
			self.doc = removeItemsFromList(tokenizeLines(open(self.txtFile, 'r').readlines(), [' ']))
			print 'self.doc:'
			print self.doc
		self.buildLevels()
				
	def setTXTList(self, txtList):
		""" Store the contents of a text list as a list of words. """
		#print 'txtList:'
		#print txtList
		#self.doc = removeItemsFromList(txtList, [' '])
		#print '(after) txtList:'
		#print self.doc
		self.doc = removeItemsFromList(txtList, [' ', ''])

	def setLevel(self, newlevel):
		oldLevel = self.level
		if 0 <= newlevel and newlevel <= self.numLevels - 1:
			self.level = newlevel
			
			#print 'cursorPosN' + `self.cursorPosN`
			segNumOld = math.floor(self.cursorPosN/self.subsegSize) 
			#print 'segNumOld' + `segNumOld`
			remainderOld = self.cursorPosN % self.subsegSize 
			#print 'remainderOld' + `remainderOld`
			if (newlevel > 0):
				cursorPos0 = segNumOld*self.segSize*self.level + remainderOld 
			else:
				cursorPos0 = segNumOld*self.segSize+remainderOld
			#print 'cursorPos0' + `cursorPos0`		
			# Update the cursor position
			if self.level > 0:
				
			
				#print 'cursorPos0 '+`self.cursorPos0`
				#print 'newlevel ' + `newlevel`
				segNumNew = math.floor(cursorPos0/(newlevel*self.segSize))
				#print 'segNumNew ' + `segNumNew`
				remainderNew = cursorPos0%(self.segSize*newlevel)   #----Alex changed
										    # it was only self.segSize, I think it
										    # it needs to be multiolied by the newlevel
				#print 'remainderNew ' + `remainderNew`
				if (remainderNew < self.subsegSize):
					newcursorPosN = segNumNew*self.subsegSize+remainderNew
				else:
					newcursorPosN = (segNumNew+1)*self.subsegSize - 1	
				
				#levelList = self.levels[self.level]
				#lastSegNum = math.floor(len(levelList)/self.subsegSize)
				#s = self.tokenize(levelList[lastSegNum], DELIMITERS)
				#numWords = (lastSegNum*self.subsegSize) + len(s)
				#if (newcursorPosN >= 0) and (newcursorPosN <= numWords):
				#	self.cursorPosN = newcursorPosN
				#else
				#	self.cursorPosN = numWords-1
				
				self.cursorPosN = newcursorPosN
				print 'cursorPosN ' + `self.cursorPosN`
					
				#segNum = math.floor(cursorPos0/self.segSize)
				#remainder = cursorPos0 % self.subsegSize
				#self.cursorPos = segNum*self.segSize + remainder
			
				#segSize = self.segSize * self.level
				#segNum = math.floor(self.cursorPos0 / segSize)
				#remainder = self.cursorPos0 % segSize
		
				#if remainder < self.subsegSize:
				#	self.cursorPosN = segNum * self.subsegSize + remainder
				#else: # Round down, lose precision -- oh well.
				#	self.cursorPosN = (segNum + 1) * self.subsegSize
			else:
				self.cursorPosN = cursorPos0
		
	def setSegAndSubsegSizes(self, segSize, subsegSize):
		""" Set the sizes of the segments and subsegments. Preprocess the file into a hierarchy of these sizes. """
		doc = self.doc
		if 0 < subsegSize and subsegSize <= segSize and segSize < len(doc):
			self.segSize = segSize
			self.subsegSize = subsegSize
			self.numLevels = math.floor((math.log(len(doc)/self.segSize)) / (math.log(2)))
			self.buildLevels()
	
	def buildLevels(self):
		""" Build levels, given the document and sizes of segments and subsegments. """
		if self.doc != []:
			self.levels = []
			doc = self.doc
			for level in range(self.numLevels):
				self.levels = self.levels + [['']]
				count = 0
				putSpace = 0
				if level==0:
					segSize = 1
					subsegSize = 1
				else:
					segSize = self.segSize * level
					subsegSize = self.subsegSize
					
				segCount = 0
				for self.cursorPos0 in range(len(doc)):
					i = self.cursorPos0
					if level==0:
						self.levels[level][segCount] = self.levels[level][segCount] + doc[i]
						if doc[i]!='\n' and doc[i]!='\r' and doc[i]!='':
							self.levels[level][segCount] = self.levels[level][segCount] + ' '
							#print ' '
						segCount = segCount + 1
						# To the list for this level, append an empty string
						self.levels[level] = self.levels[level] + ['']

					else:
						if isDelimiter(doc[i]) or doc[i]=='':
							if count % segSize <= subsegSize:
								self.levels[level][segCount] = self.levels[level][segCount] + doc[i]
								#print doc[i]
								if doc[i]=='\n' or doc[i]=='\r' or doc[i]=='':
									putSpace = 0
								if putSpace==1:
									self.levels[level][segCount] = self.levels[level][segCount] + ' '
									#print ' '
							elif doc[i]=='\n' or doc[i]=='\r':
								self.levels[level][segCount] = self.levels[level][segCount] + doc[i]
								#print doc[i]
						else:
							if count % segSize < subsegSize:
								if putSpace==1:
									self.levels[level][segCount] = self.levels[level][segCount] + ' '
									#print ' '
								putSpace = 1
								self.levels[level][segCount] = self.levels[level][segCount] + doc[i]
								#print doc[i]

							if count % segSize == 0 and count > 0:
								segCount = segCount + 1
								# To the list for this level, append an empty string
								self.levels[level] = self.levels[level] + ['']
							
							count = count + 1

			self.cursorPos0 = 0
			self.cursorPosN = 0
		
	def cposN_to_nextWord(self):
		if self.cursorPosN < len(self.levels[self.level])-1:
			self.cursorPosN = self.cursorPosN + 1
	
	def cposN_to_prevWord(self):
		if self.cursorPosN > 0:
			self.cursorPosN = self.cursorPosN - 1
	
	def cposN_to_nextLine(self):
		levelList = self.levels[self.level]
		line = math.floor(self.cursorPosN / self.numWordsPerLine)
		word = self.cursorPosN % self.numWordsPerLine
		returnTokens = 1
		remainder = len(levelList[word+1:len(levelList)-1])

		#print 'remainder: ' + `remainder`
		#print 'len(levelList): ' + `len(levelList)`
		subsegSize = self.subsegSize * self.level
		totalLines = math.floor(((len(levelList)-1)*subsegSize + remainder) / self.numWordsPerLine)
		#print 'line: ' + `line` + '; totalLines: ' + `totalLines`
		if line < totalLines:
			newCursorPosN = self.cursorPosN + self.numWordsPerLine
			if line == totalLines-1:
				newWord = newCursorPosN % self.numWordsPerLine
				if newWord > word:
					return
			self.cursorPosN = newCursorPosN
			#print 'new cursor pos: ' + `self.cursorPosN`
	
	def cposN_to_prevLine(self):
		line = math.floor(self.cursorPosN / self.numWordsPerLine)
		if line >= 1:
			self.cursorPosN = self.cursorPosN - self.numWordsPerLine
	
	def cposN_to_nextSegment(self):
		if self.level==0:
			self.cposN_to_nextWord()
		else:
			levelList = self.levels[self.level]
			segSize = self.segSize * self.level
			
			returnTokens = 1
			remainder = len(tokenizeLine(levelList[len(levelList)-1], DELIMITERS[1:len(DELIMITERS)], returnTokens))
			newCursorPosN = self.cursorPosN + segSize
			if newCursorPosN < (len(levelList)-1)*segSize + remainder:
				self.cursorPosN = newCursorPosN
	
	def cposN_to_prevSegment(self):
		if self.level==0:
			self.cposN_to_prevWord()
		else:
			segSize = self.segSize * self.level
			newCursorPosN = self.cursorPosN - segSize
			if newCursorPosN >= 0:
				self.cursorPosN = newCursorPosN
	
	def cposN_to_nextLevel(self):
		self.setLevel(self.level + 1)
	
	def cposN_to_prevLevel(self):
		self.setLevel(self.level - 1)
		
	def toString(self):
		""" Convert the document to a string representing the current level. """
		s = ''
		levelList = self.levels[self.level]
		
		#print 'cursor pos: ' + `self.cursorPosN`
		#print 'levelList:'
		#print levelList
		
		if self.level > 0:
			#segSize = self.segSize * self.level
			subsegSize = self.subsegSize
			segNum = int(math.floor(self.cursorPosN / subsegSize))
			remainder = self.cursorPosN % subsegSize
			
			#print 'segNum: ' + `segNum`
			#print 'remainder: ' + `remainder`
			
			# Get a portion of the first segment
			if segNum < len(levelList):
				returnTokens = 1
				print '\n'
				print 'cursor num: ' + `self.cursorPosN`
				print 'whole segment'
				print levelList[segNum]
				
				t = tokenizeLine(levelList[segNum], DELIMITERS, returnTokens)
				
				print 't:'
				print t	
				
				count = 0
				for j in range(len(t)):
					#print 'count: ' + `count`
					#print 't[j]: ' + t[j]
					#print 'isDelimiter(t[j]): ' + `isDelimiter(t[j])`
					if ((isDelimiter(t[j])==0) and t[j]!=''):
						count = count + 1
					if count == remainder:
						break
				
				for k in range(j+1, len(t)):
					s = s + t[k]
					
				print 'remainder of segment: '
				print s
				
				#print t[int(remainder):len(t)-1]
				#for j in range(remainder, len(t)):
				#	s = s + t[j]
			for i in range(segNum + 1, len(levelList)):
				s = s + levelList[i]
		else:
			for i in range(self.cursorPosN, len(levelList)):
				s = s + levelList[i]
		#print s
		return s

	def speak(self):
		""" Speak the entire document. """
		self.speak(self.toString)

#-------------------------------------------------------------------------------
# Unnecessary functions of class Hierarchy
#-------------------------------------------------------------------------------
	def cpos0_to_cposN(self):
		""" Given cursor position cpos0 on level 0, convert to cposN on current level N. Potentially loses precision. """
		if self.level==0:
			self.cursorPosN = self.cursorPos0
		else:
			segSize = self.segSize * self.level
			segNum = math.floor(self.cursorPos0 / segSize)
			remainder = self.cursorPos0 % segSize
		
			if remainder < self.subsegSize:
				self.cursorPosN = segNum * self.subsegSize + remainder
			else: # Round down, lose precision -- oh well.
				self.cursorPosN = (segNum + 1) * self.subsegSize
		
	def cposN_to_cpos0(self):
		""" Given cursor position cposN on current level N, convert to cpos0 on level 0. """
		if self.level==0:
			self.cursorPos0 = self.cursorPosN
		else:
			segNum = math.floor(self.cursorPosN / self.subsegSize)
			remainder = self.cursorPosN % self.subsegSize
			
			self.cursorPos0 = (segNum * self.segSize) + remainder

#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
#///////////////////////////////////////////////////////////////////////////////
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
def speakMultipleStreams(words, numSources=3, doShiftPos=1):
	""" Speak the files from numSources sound sources simultaneously. """

	
	# Split the list of words into numSources lists, one for each sound source.
	words2 = []
	for i in range(numSources):
		words2 = words2 + ['']
	for i in range(len(words)):
		if(isDelimiter(words2[i%numSources]) == 0):
			words2[i%numSources] = words2[i%numSources] + ' ' + words[i]
		
#	for i in range(numSources):
#		print '-------------------------------------\n' + '"' + words2[i] + '"'
	
	SLEEP_TIME = 0.20 * len(words) # Approx time to read a file; BAAAD HACK
		
	# Array of sound sources
	sources = []
	sl = pySoundListener(numSources)
	
	mutex = thread.allocate_lock()	
	
	# Initialize the numSources sound sources to store one of the newly-created *.wav files.
	voices = ['MSSam', 'MSMary','MSMike']
	for i in range(numSources):
		mutex.acquire()
		wavFile = 'tmp' + `i` + `int(time.time())` + '.wav'
		tts = pyTTS()
		tts.SetVoiceByName(voices[i%3])
		tts.SpeakToWave(wavFile, words2[i])	
		sources = sources + [sl.New(wavFile)]
		tts.SetRate(-5)
		mutex.release()
		
		mutex.acquire()
		print 'Done writing files'
		mutex.release()

	
	if doShiftPos==1:
		# Set the spatial parameters: initial position; sizes of words, lines, and spaces b/w sources; and number of position shifts.
		left = -20
		right = 10
		top = -5
		bottom = 5
		
		numWordsPerLine = 20  # Actually, a "word" is a position shift
		numLinesPerPage = 20  # Actually, a "line" is a set of position shifts
		spaceBtwSources = 10
		numPosShifts = 10
		
		# Spatial shift in (x,y) per (word on a line, line on a page).
		dx = (right - left)/numWordsPerLine
		dy = (bottom - top)/numLinesPerPage

		# Initial position, and numbers of words and lines read.
		pos = [left, top, 0]
		#pos =[0, 0, 0]
		numWords = 0
		numLines = 0
		numLinesInFile = 20


		if(numSources == 1):
			sources[0].setPosition([0,0,0])
		elif (numSources ==2 ):
			sources[1].setPosition([-5, pos[1], pos[2]])
			sources[0].setPosition([15, pos[1], pos[2]])
		elif (numSources == 3):
			sources[0].setPosition([-10, pos[1], pos[2]])
			sources[1].setPosition([0, pos[1], pos[2]])
			sources[2].setPosition([10, pos[1], pos[2]])

		elif (numSources == 4):
			sources[0].setPosition([-15, pos[1], pos[2]])
			sources[1].setPosition([-2, pos[1], pos[2]])
			sources[2].setPosition([2, pos[1], pos[2]])
			sources[3].setPosition([-15, pos[1], pos[2]])
			
			
			
		


		# Initialize positions of sources and start them playing
		for j in range(numSources):
			sources[j].Play()
		sleep(SLEEP_TIME)
#		sources[0].setPosition([-15, pos[1], pos[2]])
#		sources[1].setPosition([15, pos[1], pos[2]])
#		sources[0].Play()
#		sources[1].Play()

		
#		sleep(SLEEP_TIME)


#		for k in range(numLinesInFile):
#			for pos[0] in range(left, right+1):
#				for j in range(numSources):
#					sources[j].setPosition([pos[0] + (j+1)*spaceBtwSources,
#						pos[1], pos[2]])			
#					sources[j].Play()
#					sleep(0.25)
#					sources[j].Pause()

				
				#s1.setPosition([pos[0],   pos[1], pos[2]])
#				sources[0].setPosition([left + (right - pos[0]), pos[1], pos[2]])
				#s1.Play()
#				sources[0].Play()
				#sleep(0.25)
				#s1.Pause()
#				sleep(0.25)
#				sources[0].Pause()
				
				
		# Iterate through the number of position shifts
#		for i in range(numPosShifts):
#			#sleep(SLEEP_TIME/numPosShifts)
#			
#			if numWords == numWordsPerLine:
#				numWords = 0
#				numLines = numLines + 1
#				pos[0] = left
#				pos[1] = pos[1] + dy
#			else:
#				numWords = numWords + 1
#				pos[0] = pos[0] + dx
#		
#			if numLines == numLinesPerPage:
#				numLines = 0
#				pos[1] = top
#
#						
#			# Update positions of sources	
#			for j in range(numSources):
#				sources[j].setPosition([pos[0] + (j+1)*spaceBtwSources,
#								pos[1], pos[2]])
			
					
#		if(numSources == 1) :
#			for pos[0] in range (left, right+1):
#				sources[0].setPosition([pos[0], pos[1], pos[2]])
#				sources[0].Play()
#			sleep(SLEEP_TIME)
#		else:
#			for pos[0] in range (left, right+1):
#				if(pos[0] == right):
#					pos[1] = pos[1] + dy
#				else:
#					pos[0] = pos[0] + dx #did not finish
				
				
	# END 'if doShiftPos==1:'
	else:
		for i in range(numSources):
			sources[i].setPosition([0,0,0])
			sources[i].Play()
		sleep(SLEEP_TIME)

		#print(sources)

	sl.Delete()

def speakSpatialOrientation(words, numSources=1, doShiftPos=1):

	#print(words)
# Split the list of words into numSources lists, one for each sound source.
	words2 = []
	for i in range(numSources):
		words2 = words2 + ['']
	for i in range(len(words)):
		if(isDelimiter(words2[i%numSources]) == 0):
			words2[i%numSources] = words2[i%numSources] + ' ' + words[i]

	
	SLEEP_TIME = 0.20 * len(words) # Approx time to read a file; BAAAD HACK
		
	# Array of sound sources
	sources = []
	sl = pySoundListener(numSources)
	
	mutex = thread.allocate_lock()	
		
	# Initialize the numSources sound sources to store one of the newly-created *.wav files.
	voices = ['MSSam', 'MSMary','MSMike']
	for i in range(numSources):
		mutex.acquire()
		wavFile = 'tmp' + `i` + `int(time.time())` + '.wav'
		tts = pyTTS()
		tts.SetVoiceByName(voices[i%3])
		tts.SpeakToWave(wavFile, words2[i])	
		sources = sources + [sl.New(wavFile)]
		tts.SetRate(-5)
		mutex.release()
		
		mutex.acquire()
		print 'Done writing files'
		mutex.release()

		
	
	if doShiftPos==1:
		# Set the spatial parameters: initial position; sizes of words, lines, and spaces b/w sources; and number of position shifts.
		left = -10
		right = 10
		top = -5
		bottom = 5
		
		numWordsPerLine = 20  # Actually, a "word" is a position shift
		numLinesPerPage = 20  # Actually, a "line" is a set of position shifts
		spaceBtwSources = 10
		numPosShifts = 10
		
		# Spatial shift in (x,y) per (word on a line, line on a page).
		dx = (right - left)/numWordsPerLine
		dy = (bottom - top)/numLinesPerPage

		# Initial position, and numbers of words and lines read.
		pos = [left, top, 0]
		#pos =[0, 0, 0]
		numWords = 0
		numLines = 0
		numLinesInFile = 0

		for i in range(len(words)):
			if (words[i] == '\n'):
				numLinesInFile = numLinesInFile + 1
		print(numLinesInFile)

#		numLinesInFile = len(words)/10
		

		for k in range(numLinesInFile):
			for pos[0] in range(left, right+1):
				sources[0].setPosition([left + (right - pos[0]), pos[1], pos[2]])
				sources[0].Play()
				sleep(0.25)
				sources[0].Pause()

		sl.Delete()

				

def speakMultipleStreamsFromFile(txtFile, numSources=3, doShiftPos=0):
	words = removeItemsFromList(
		tokenizeLines(open(txtFile, 'r').readlines()), [' ', ''])
	#speakMultipleStreams(words, numSources, doShiftPos)
	speakSpatialOrientation(words, numSources, doShiftPos)
#-------------------------------------------------------------------------------
#-------------------------------------------------------------------------------
""" # BEGIN COMMENT 
# Move 3 city sources
if __name__ == '__main__':
	sl = pySoundListener(3)
	sources = []
	for i in range(3):
		sources.append(sl.New('city.wav'))
		sources[i].looping = True
	left = -50
	right = 50
	pos = [left,0,0]
	dx = 5
	for count in range((right-left)/dx + 2): # e.g., -15,-10,-5,0,5,10,15
		pos[0] = pos[0] + dx
		for i in range(3):
			sources[i].setPosition([pos[0] + dx*(i+1), pos[1], pos[2]])
			sources[i].Play()
		sleep(0.25)
		for i in range(3):
			sources[i].Pause()

""" # END COMMENT	
""" # BEGIN COMMENT
# Move 1 city source
if __name__ == '__main__':
	sl = pySoundListener()
	s = sl.New('city.wav')
	s.looping = True
	left = -10
	right = 10
	pos = [left,0,0]
	for pos[0] in range(left, right+1):
		s.setPosition(pos)
		s.Play()
		sleep(0.25)
		s.Pause()
	sl.Delete()
""" # END COMMENT

""" # BEGIN COMMENT  

# TRY THIS: IT'S COOL!!!
# Sounds cross over each other: City goes L-R, flute goes R-L.
if __name__ == '__main__':
	sl = pySoundListener()
	s1 = sl.New('city.wav')
	s2 = sl.New('BoyBathing.wav')
	s1.looping = True
	#s2.looping = True
	numLines = 10
	left = -15
	right = 10
	pos = [left,0,0]
	for i in range(numLines):
		for pos[0] in range(left, right+1):
			#s1.setPosition([pos[0],   pos[1], pos[2]])
			s2.setPosition([left + (right - pos[0]), pos[1], pos[2]])
			#s1.Play()
			s2.Play()
			sleep(0.25)
			#s1.Pause()
			s2.Pause()
	sl.Delete()
""" # END COMMENT
""" BEGIN COMMENT 

if __name__ == '__main__':


""" # END COMMENT
""" BEGIN COMMENT
# Move 3 Crab.txt sources
if __name__ == '__main__':
	doShiftPos = 0
	numSources = 3 # most understandable with only 1 source, and doShiftPos==0
	speakMultipleStreamsFromFile('Crab.txt', numSources, doShiftPos)
""" # END COMMENT

""" BEGIN COMMENT 

# Move 1 Crab.txt source  
if __name__ == '__main__':
	doShiftPos = 1
	numSources = 1
	speakMultipleStreamsFromFile('Crab2.txt', numSources, doShiftPos)

""" # END COMMENT
#-------------------------------------------------------------------------------
# Test functions for class Hierarchy
#-------------------------------------------------------------------------------
# Test movement to next level -- WORKS
""" BEGIN COMMENT
if __name__ == '__main__':
	h = Hierarchy('Crab.txt')
	h.setSegAndSubsegSizes(6,3)
	for level in range(h.numLevels):
		h.setLevel(level)
		print '-----------------------------------------\nlevel: ' + `h.level`
		print h.toString()
""" # END COMMENT

""" BEGIN COMMENT
# Test movement to next word -- WORKS
if __name__ == '__main__':
	h = Hierarchy('Crab.txt')
	h.setSegAndSubsegSizes(6,3)
	for level in range(h.numLevels):
		h.setLevel(level)
		print '--------------------------------------\nlevel: ' + `h.level`
		h.cursorPosN = 0
		for cursorShift in range(5):
			print '----------------------------------\nshift: ' + `cursorShift`
			print h.toString()
			h.cposN_to_nextWord()
""" # END COMMENT

""" BEGIN COMMENT
# Test movement to next segment -- DOES NOT QUITE WORK
if __name__ == '__main__':
	h = Hierarchy('Crab.txt')
	h.setSegAndSubsegSizes(6,3)
	for level in range(h.numLevels):
		h.setLevel(level)
		print '--------------------------------------\nlevel: ' + `h.level`
		h.cursorPosN = 0
		for segShift in range(5):
			print '----------------------------------\nshift: ' + `segShift`
			print h.toString()
			h.cposN_to_nextSegment()
""" # END COMMENT

""" BEGIN COMMENT
# Test movement to next line -- DOES NOT QUITE WORK
if __name__ == '__main__':
	h = Hierarchy('Crab.txt')
	h.setSegAndSubsegSizes(6,3)
	for level in range(h.numLevels):
		h.setLevel(level)
		print '--------------------------------------\nlevel: ' + `h.level`
		h.cursorPosN = 0
		for lineShift in range(5):
			print '----------------------------------\nshift: ' + `lineShift`
			print h.toString()
			h.cposN_to_nextLine()
""" # END COMMENT
