from wxPython.wx import *
from pyTTS import *
import os

from speech import *
from speech2 import *

ID_ABOUT=101
ID_OPEN=102
ID_SAVE=103
ID_BUTTON_PLAY=110
ID_BUTTON_SKIP=120
ID_BUTTON_PAUSE=130
ID_BUTTON_JUMP=140
ID_BUTTON_SKIM=150
ID_BUTTON_REMOVE_COMMON_WORDS=160
ID_BUTTON_RESTORE_ORIGINAL=170
ID_VOICES_0=180
ID_EXIT=190
ID_BUTTON_STOP = 200

ID_DISPLAY_WINDOW=1010

ID_ORIGINAL = 300
ID_REMOVE_COMMON = 310
ID_PHONEMES = 320
ID_DROP_PHONEMES = 330
ID_BLEND_PHONEMES = 340

ID_TOOLBAR_OPEN=400
ID_TOOLBAR_SAVE=410
ID_TOOLBAR_RIGHT=420
ID_TOOLBAR_LEFT=430
ID_TOOLBAR_DOWN=440
ID_TOOLBAR_UP=450
ID_TOOLBAR_UPLEVEL=460
ID_TOOLBAR_DOWNLEVEL=470
ID_TOOLBAR_LEFTSEG=480
ID_TOOLBAR_RIGHTSEG=490

ID_HIERARCHY_MENU=500
ID_NUMERIC_HIERARCHY=510
ID_SYNTACTIC_HIERARCHY=520
ID_SPATIAL_SOUND=530
ID_SPATIAL_ORIENTATION = 540

ID_SLOW = 600
ID_FAST = 610
ID_NORMAL = 620
ID_MED = 630

ID_KEY_LEFTSEG = 700
ID_KEY_RIGHTSEG = 710
ID_KEY_LEFT = 720
ID_KEY_RIGHT = 730
ID_KEY_UP = 740
ID_KEY_DOWN = 750
ID_KEY_UP_H = 760
ID_KEY_DOWN_H = 770

ID_MIKE = 5000
ID_MARY = 5001
ID_SAM = 5002	

ID_KEY_PLAY = 5005
ID_KEY_STOP = 5006



gpaused = 1
gstopped = 1
gplay = 0
gplay_test = 0

hash = createDictionary('Phonemes.txt',1)  #Read in phoneme dictionary
#hash = createDictionary('PhonemeSmall.txt',1)  #Read in short phoneme file

class MainWindow(wxFrame):
	def __init__(self,parent,id,title):
		
#=======================================================================
		# Member variables
		
#=======================================================================
		self.dirname='' # Directory in which to display file dialog box
		self.ttw3d = Hierarchy() # Text-to-speech object
		self.ifPause = 0 #1 if Pause button cliked
		self.gplay = 1
		self.voices = self.ttw3d.getVoices()
		self.key_off = true
		self.key_on = false
		self.haveFocus = false
		
		wxFrame.__init__(self,parent,-4, title, style=wxDEFAULT_FRAME_STYLE|
				 wxNO_FULL_REPAINT_ON_RESIZE)
		self.control = wxTextCtrl(self, ID_DISPLAY_WINDOW,
						  style=wxTE_MULTILINE)
		self.CreateStatusBar() # A Statusbar in the bottom of the window 
		
#=======================================================================
		# Toolbar
		# Python22\Lib\site-packages\wxPython\samples\pySketch\images
		
#=======================================================================
		self.toolbar = self.CreateToolBar(
			wxTB_HORIZONTAL | wxNO_BORDER | wxTB_FLAT)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_OPEN, wxBitmap("images/open.bmp", wxBITMAP_TYPE_BMP),
			"Open")
		EVT_MENU(self, ID_TOOLBAR_OPEN, self.OnOpen)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_SAVE, wxBitmap("images/save.bmp", wxBITMAP_TYPE_BMP),
			"Save")
		EVT_MENU(self, ID_TOOLBAR_SAVE, self.OnSave)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_LEFTSEG, wxBitmap("images/left_segment.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor left one segment")
		EVT_MENU(self, ID_TOOLBAR_LEFTSEG, self.OnMoveCursorLeftOneSegment)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_RIGHTSEG, wxBitmap("images/right_segment.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor right one segment")
		EVT_MENU(self, ID_TOOLBAR_RIGHTSEG, self.OnMoveCursorRightOneSegment)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_LEFT, wxBitmap("images/left_word.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor left one word")
		EVT_MENU(self, ID_TOOLBAR_LEFT, self.OnMoveCursorLeftOneWord)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_RIGHT, wxBitmap("images/right_word.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor right one word")
		EVT_MENU(self, ID_TOOLBAR_RIGHT, self.OnMoveCursorRightOneWord)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_DOWN, wxBitmap("images/down_line.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor down one line")
		EVT_MENU(self, ID_TOOLBAR_DOWN, self.OnMoveCursorDownOneLine)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_UP, wxBitmap("images/up_line.bmp",
			wxBITMAP_TYPE_BMP), "Move cursor up one line")
		EVT_MENU(self, ID_TOOLBAR_UP, self.OnMoveCursorUpOneLine)

		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_DOWNLEVEL, wxBitmap("images/down_level.bmp",
			wxBITMAP_TYPE_BMP), "Move down one level")
		EVT_MENU(self, ID_TOOLBAR_DOWNLEVEL, self.OnMoveDownOneLevel)
		
		self.toolbar.AddSimpleTool(
			ID_TOOLBAR_UPLEVEL, wxBitmap("images/up_level.bmp",
			wxBITMAP_TYPE_BMP), "Move up one level")
		EVT_MENU(self, ID_TOOLBAR_UPLEVEL, self.OnMoveUpOneLevel)
		
		self.toolbar.Realize()
		
#=======================================================================
		# File menu
		
#=======================================================================
		filemenu= wxMenu()
		filemenu.Append(ID_OPEN, "&Open"," Open a file to edit")
		EVT_MENU(self, ID_OPEN, self.OnOpen)
		filemenu.AppendSeparator()
		filemenu.Append(ID_SAVE, "&Save"," Save the current screen display")
		EVT_MENU(self, ID_SAVE, self.OnSave)
		filemenu.AppendSeparator()
		filemenu.Append(ID_ABOUT, "&About"," Information about this program")
		EVT_MENU(self, ID_ABOUT, self.OnAbout)
		filemenu.AppendSeparator()
		filemenu.Append(ID_EXIT,"&Exit"," Terminate the program")
		EVT_MENU(self, ID_EXIT, self.OnExit)
		
		
#=======================================================================
		# Voice menu
		
#=======================================================================

		voicemenu = wxMenu()
		voices = self.ttw3d.getVoices()
		v = 0
		for voice in voices.keys():
			voicemenu.Append(ID_VOICES_0+v, "&"+voice, "Set voice to "+voice)
			EVT_MENU(self, ID_VOICES_0+v, self.OnSetVoice)
			v = v+1
		
#=======================================================================
		# Hierarchy menu
		
#=======================================================================
		hierMenu = wxMenu()
		hierMenu.Append(ID_ORIGINAL, "&Original Text",
			"Read with original (highest) level of detail")
		
		hierMenu.Append(ID_NUMERIC_HIERARCHY, "&Build Hierarchy (Numeric)",
			"Build hierarchy based on numeric spacing")
		EVT_MENU(self, ID_NUMERIC_HIERARCHY,
		self.OnClickBuildNumericHierarchy)
		
		
		
		#hierarchyMenu = wxMenu()
		#hierarchyMenu.Append(ID_SYNTACTIC_HIERARCHY, "&Syntactic Spacing",
		#	"Build hierarchy based on syntactic spacing")
		#EVT_MENU(self, ID_SYNTACTIC_HIERARCHY,
		#	self.OnClickBuildSyntacticHierarchy)
		#optionsMenu.AppendMenu(ID_HIERARCHY_MENU,
		#	"Build Hierarchy", hierarchyMenu)
		
		

#=======================================================================
		# Phoneme menu
		
#=======================================================================
		phonemeMenu = wxMenu()		
		
		phonemeMenu.Append(ID_ORIGINAL, "&Original Text",
			"Read with original (highest) level of detail")
		EVT_MENU(self, ID_ORIGINAL, self.OnClickRestoreOriginal)
		
		phonemeMenu.Append(ID_PHONEMES, "Change To Phonemes", "Change To Phonemes")
		EVT_MENU(self, ID_PHONEMES, self.OnClickChangeToPhonemes)
		
		phonemeMenu.Append(ID_REMOVE_COMMON, "Remove Common Words", "Remove Common Words")
		EVT_MENU(self, ID_REMOVE_COMMON, self.OnClickRemoveCommonWords)

		phonemeMenu.Append(ID_DROP_PHONEMES, "Drop Phonemes", "Drop Phonemes")
		EVT_MENU(self, ID_DROP_PHONEMES, self.OnDropPhonemes)
		
		phonemeMenu.Append(ID_BLEND_PHONEMES, "Blend Phonemes", "Blend Phonemes")
		EVT_MENU(self, ID_BLEND_PHONEMES, self.OnBlendPhonemes)
		
		
#=======================================================================
		# Spatial Sound menu
		
#=======================================================================	
		spatialMenu = wxMenu()	

		spatialMenu.Append(ID_SPATIAL_SOUND, "Spatial Sound", "Read with spatial sound")
		EVT_MENU(self, ID_SPATIAL_SOUND, self.OnClickReadWithSpatialSound)
		spatialMenu.Append(ID_SPATIAL_ORIENTATION, "Spatial Orientation", "Read with spatial orientation")
		EVT_MENU(self, ID_SPATIAL_ORIENTATION, self.OnClickReadWithSpatialOrientation)
		
#========================================================================
		#Rate menu
		
#========================================================================
		rateMenu = wxMenu()
		rateMenu.Append(ID_SLOW, "&Slow", "Read text slower than normal")
		EVT_MENU(self, ID_SLOW, self.onClickSlow)
		rateMenu.Append(ID_NORMAL, "&Normal", "Read text at normal speed")
		EVT_MENU(self, ID_NORMAL, self.onClickNormal)
		rateMenu.Append(ID_MED, "&Medium Fast", "Read text medium fast")
		EVT_MENU(self, ID_MED, self.onClickMedium)
		rateMenu.Append(ID_FAST, "&Fast", "Read text faster than normal")
		EVT_MENU(self, ID_FAST, self.onClickFast)
		
#=========================================================================
		#Keyboard commands menu
		
#==========================================================================
		commandMenu = wxMenu()
		commandMenu.Append(ID_KEY_PLAY, "&Play\tCtrl+P", "Use keyboard to play")
		EVT_MENU(self, ID_KEY_PLAY, self.OnKeyPlay)
		
		commandMenu.Append(ID_KEY_STOP, "&Stop\tCtrl+S", "Use keyboard to stop")
		EVT_MENU(self, ID_KEY_STOP, self.OnKeyStop)	
		
		commandMenu.AppendSeparator()
		
		#jumping "small" chunks
		commandMenu.Append(ID_KEY_LEFT, "Move Left Word\tCtrl+Left", "Move left one word")
		EVT_MENU(self, ID_KEY_LEFT, self.OnMoveCursorLeftOneWord)
		commandMenu.Append(ID_KEY_RIGHT, "Move Right Word\tCtrl+Right", "Move right one word")
		EVT_MENU(self, ID_KEY_RIGHT, self.OnMoveCursorRightOneWord)
		
		commandMenu.Append(ID_KEY_UP, "Move Up Line\tCtrl+Up", "Move up one line")
		EVT_MENU(self, ID_KEY_UP, self.OnMoveCursorUpOneLine)
		commandMenu.Append(ID_KEY_DOWN, "Move Down Line\tCtrl+Down", "Move down one line")
		EVT_MENU(self, ID_KEY_DOWN, self.OnMoveCursorDownOneLine)
		
		commandMenu.AppendSeparator()
		
		#jumping "large" chunks
		commandMenu.Append(ID_KEY_LEFTSEG, "Move Left Seg\tCtrl+Shift+Left", "Move left one segment")
		EVT_MENU(self, ID_KEY_LEFTSEG, self.OnMoveCursorLeftOneSegment)
		commandMenu.Append(ID_KEY_RIGHTSEG, "Move Right Seg\tCtrl+Shift+Right", "Move right one segment")
		EVT_MENU(self, ID_KEY_RIGHTSEG, self.OnMoveCursorRightOneSegment)
		
		commandMenu.Append(ID_KEY_UP_H, "Move Up Level\tCtrl+Shift+Up", "Move up one level")
		EVT_MENU(self, ID_KEY_UP_H, self.OnMoveUpOneLevel)
		commandMenu.Append(ID_KEY_DOWN_H, "Move Down Level\tCtrl+Shift+Down", "Move down one level")
		EVT_MENU(self, ID_KEY_DOWN_H, self.OnMoveDownOneLevel)
				
#=======================================================================
		# Menu bar
		
#=======================================================================
		menuBar = wxMenuBar()
		menuBar.Append(filemenu,"&File")
		menuBar.Append(voicemenu,"&Voices")
		menuBar.Append(rateMenu, "&Rate")
		menuBar.Append(hierMenu,"&Hierarchy")
		menuBar.Append(phonemeMenu,"&Phonemes")
		menuBar.Append(spatialMenu, "&Spatial Sound")
		menuBar.Append(commandMenu, "&Keyboard")
				
		# Add the menubar to the window.
		self.SetMenuBar(menuBar)
		
#=======================================================================
		# Buttons
		
#=======================================================================
		self.sizer2 = wxBoxSizer(wxHORIZONTAL)
		self.buttons=[]
		
		# Why must "self.buttons.append()" and "EVT_BUTTON" go in a for-loop?
		# Seems they should be done only once, yet if I remove them from the
		# for-loop, this program will not compile! (Suzanne)
		#
		for i in range(3):
			self.buttons.append(wxButton(self, ID_BUTTON_PLAY, "Play"))
			EVT_BUTTON(self, ID_BUTTON_PLAY, self.OnClickPlay)
			
			self.buttons.append(wxButton(self, ID_BUTTON_PAUSE, "Pause"))
			EVT_BUTTON(self, ID_BUTTON_PAUSE, self.OnClickPause)
						
			self.buttons.append(wxButton(self, ID_BUTTON_STOP, "Stop"))
			EVT_BUTTON(self, ID_BUTTON_STOP, self.OnClickStop)
			
			self.sizer2.Add(self.buttons[i],1,wxEXPAND)
			
		# Use some sizers to see layout options
		self.sizer=wxBoxSizer(wxVERTICAL)
		self.sizer.Add(self.control,1,wxEXPAND)
		self.sizer.Add(self.sizer2,0,wxEXPAND)

		# Layout sizers
		self.SetSizer(self.sizer)
		self.SetAutoLayout(1)
		self.sizer.Fit(self)
		
		self.ttw3d.Speak("Welcome to the Sckimmer!!!!!")
#=======================================================================
		# Text attributes of window
		# http://parthe.lpthe.jussieu.fr/~zeitlin/wxWindows/docs/wxwin485.htm
		
#=======================================================================
		# *** BUG: THIS DOES NOT WORK TO SET TEXT ATTRIBUTES ***
		#
		textColor = wxColour(0,0,0)
		bgdColor = wxColour(1,1,1)
		font = wxFont(16, wxROMAN, wxNORMAL, wxNORMAL)
		self.control.SetDefaultStyle(wxTextAttr(textColor, bgdColor, font))
		#self.control.curFont = font
		
		# Set a callback for characters typed
		# *** BUG: WILL NOT COMPILE ***
		#EVT_CHAR(self.control, ID_DISPLAY_WINDOW, self.OnTypeCharIntoDisplay)
		
		self.Show(1)

	def OnAbout(self,e):
		d= wxMessageDialog( self, " Speech synthesizer GUI\n"
							" in wxPython","About GUI Editor", wxOK)
							# Create a message dialog box 
		d.ShowModal() # Shows it 
		d.Destroy() # finally destroy it when finished. 

	def OnExit(self,e):
		self.Close(true)  # Close the frame. 

	def OnOpen(self,e):
		""" Open a file and render it to the screen display. """
		dlg = wxFileDialog(self, "Open", self.dirname, "", "*.txt", wxOPEN)
		if dlg.ShowModal() == wxID_OK:
			self.dirname = dlg.GetDirectory()
			self.ttw3d.setTXTFile(dlg.GetDirectory() + "\\" + dlg.GetFilename())
			self.DisplayTXTFile()
		dlg.Destroy()
		
	def OnSave(self,e):
		""" Save the current screen display to a file. """
		dlg = wxFileDialog(self, "Save As", self.dirname, "", "*.txt", wxSAVE)
		if dlg.ShowModal() == wxID_OK:
			self.dirname = dlg.GetDirectory()
			lines = self.GetDisplayText()
			f = file(dlg.GetDirectory() + "\\" + dlg.GetFilename(),'w')
			f.writelines(lines)
			f.close()
		dlg.Destroy()
		
	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorRightOneWord(self,e):
		print '** OnMoveCursorRightOneWord'
		self.ttw3d.cposN_to_nextWord()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()

	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorLeftOneWord(self,e):
		print '** OnMoveCursorLeftOneWord'
		self.ttw3d.cposN_to_prevWord()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
	
	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorDownOneLine(self,e):
		print '** OnMoveCursorDownOneLine'
		self.ttw3d.cposN_to_nextLine()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
	
	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorUpOneLine(self,e):
		print '** OnMoveCursorUpOneLine'
		self.ttw3d.cposN_to_prevLine()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
	
	#################
	# DOES NOT WORK #
	#################
	def OnMoveUpOneLevel(self,e):
		print '** OnMoveUpOneLevel'
		self.ttw3d.cposN_to_nextLevel()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
	
	#################
	# DOES NOT WORK #
	#################
	def OnMoveDownOneLevel(self,e):
		print '** OnMoveDownOneLevel'
		self.ttw3d.cposN_to_prevLevel()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
		
	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorRightOneSegment(self,e):
		print '** OnMoveCursorRightOneSegment'
		self.ttw3d.cposN_to_nextSegment()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
	
	#################
	# DOES NOT WORK #
	#################
	def OnMoveCursorLeftOneSegment(self,e):
		print '** OnMoveCursorLeftOneSegment'
		self.ttw3d.cposN_to_prevSegment()
		self.SetDisplayText([self.ttw3d.toString()])
		self.ttw3d.Stop()
		self.SpeakDisplayText()
		
	#===========================================================================
	# Suzanne's voice function
	#
	def OnSetVoice(self,e):
		evtId = e.GetId()
		v = ID_VOICES_0
		for voice in self.voices.keys():
			if v == evtId:
				print voice
				self.ttw3d.setVoice(voice)
				break
			v = v+1
			
	#===========================================================================
	# Alex's voice functions
	#		
	def onSetVoiceMike(self,e):
		self.ttw3d.SetVoice(self.voices['MSMike'])

	def onSetVoiceMary(self,e):
		self.ttw3d.SetVoice(self.voices['MSMary'])		

	def onSetVoiceSam(self,e):
		self.ttw3d.SetVoice(self.voices['MSSam'])

	def onSetVoiceMichelle(self,e):
		self.ttw3d.SetVoice(self.voices['LHMICHELLE'])
		
	def onSetVoiceMichael(self,e):
		self.ttw3d.SetVoice(self.voices['LHMICHAEL'])
	#===========================================================================

	def OnClickPlay(self,e):
		if(self.gplay!=0):
			self.SpeakDisplayText()
		else:
			self.ttw3d.Resume()

	def OnClickStop(self,e):
		self.gplay = 1
		self.ttw3d.Stop()
			
	def OnClickPause(self,e):
		self.ttw3d.Pause()
		self.gplay = 0
			
	def OnClickSkip(self,e):
		self.ttw3d.Speak("Skip not yet implemented")

	def OnClickJump(self,e):
		self.ttw3d.Speak("Jump not yet implemented")

	def OnKeyPlay(self, e):
		self.control.AppendText("")
		if(self.gplay!=0):
			self.SpeakDisplayText()
		else:
			self.ttw3d.Resume()

	def OnKeyStop(self, e):
		self.control.AppendText("")
		self.gplay = 1
		self.ttw3d.Stop()
		
	#def OnKeyMoveCursorLeftOneSegment(self,e):
	#	self.control.AppendText("")
		
		
	def OnClickRemoveCommonWords(self,e):
		""" Set the text-to-speech object to speak the file with the common 
			words removed. """
		listDictionary = tokenizeLines(
			file('CommonWords.txt', 'r').readlines(), [' '], 0)
		listIn = self.GetDisplayTextAsWordList()
		listOut = removeWordsFromWordList(listIn, listDictionary, 0)
		self.SetDisplayText(listOut)

	def OnClickChangeToPhonemes(self,e):
		"""Change the displayed text to phonemes"""
		listIn = self.GetDisplayTextAsWordList()
		listOut = changeWordsToPhonemes(listIn, hash, 1)
		self.SetDisplayText(listOut)
	
	def OnDropPhonemes(self,e):
		"""Drop unstressed syllables"""
		listIn = self.GetDisplayTextAsWordList()
		listOut = dropPhonemes(listIn, hash)
		self.SetDisplayText(listOut)
	
	def OnBlendPhonemes(self,e):
		"""Drop spaces"""
		listIn = self.GetDisplayTextAsWordList()
		listOut = blendPhonemes(listIn, hash)
		self.SetDisplayText(listOut)
	
		
	def OnClickBuildNumericHierarchy(self,e):
		# TO DO
		print '** OnClickBuildNumericHierarchy'
   		win = wxDialog(
   			frame, -1, "Build Numeric Hierarchy", size=wxSize(350, 200),
   			style = wxCAPTION | wxSYSTEM_MENU | wxTHICK_FRAME
   			#style = wxDEFAULT_DIALOG_STYLE
			)

		sizer = wxBoxSizer(wxVERTICAL)

		label = wxStaticText(
			win, -1, "Build Numeric Hierarchy\n(e.g., Try (3,6))")
		sizer.Add(label, 0, wxALIGN_CENTRE|wxALL, 5)

		box = wxBoxSizer(wxHORIZONTAL)

		label = wxStaticText(win, -1, "Res:")
		box.Add(label, 0, wxALIGN_CENTRE|wxALL, 5)

		resText = wxTextCtrl(win, -1, "", size=(80,-1))
		box.Add(resText, 1, wxALIGN_CENTRE|wxALL, 5)

		sizer.AddSizer(box, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5)
		
		box = wxBoxSizer(wxHORIZONTAL)

		label = wxStaticText(win, -1, "Size:")
		box.Add(label, 0, wxALIGN_CENTRE|wxALL, 5)

		sizeText = wxTextCtrl(win, -1, "", size=(80,-1))
		box.Add(sizeText, 1, wxALIGN_CENTRE|wxALL, 5)

		sizer.AddSizer(box, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5)

		line = wxStaticLine(win, -1, size=(20,-1), style=wxLI_HORIZONTAL)
		sizer.Add(line, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxRIGHT|wxTOP, 5)

		box = wxBoxSizer(wxHORIZONTAL)

		btn = wxButton(win, wxID_OK, " OK ")
		btn.SetDefault()
		box.Add(btn, 0, wxALIGN_CENTRE|wxALL, 5)

		btn = wxButton(win, wxID_CANCEL, " Cancel ")
		box.Add(btn, 0, wxALIGN_CENTRE|wxALL, 5)

		sizer.AddSizer(box, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5)

		win.SetSizer(sizer)
		win.SetAutoLayout(true)
		sizer.Fit(win)

		val = win.ShowModal()
		if val == wxID_OK:
			res = atoi(resText.GetValue())
			size = atoi(sizeText.GetValue())
			if (res < 1 or size < 1 or res > size):
				print '** Error: Res and size must be positive, and res must be greater than size'
			else:
				listIn = self.GetDisplayTextAsWordList()
				#print 'listIn:'
				#print listIn
				self.ttw3d.setTXTList(listIn)
				self.ttw3d.setSegAndSubsegSizes(size, res)
				listOut = self.ttw3d.toString()
				self.SetDisplayText(listOut)

	def OnClickBuildSyntacticHierarchy(self,e):
		#
		# TO DO
		#
		return
		
	def OnClickReadWithSpatialSound(self,e):
		#
		# TO DO
		#
		print '** OnClickReadWithSpatialSound'
   		win = wxDialog(
   			frame, -1, "Read with Spatial Sound", size=wxSize(350, 200),
   			style = wxCAPTION | wxSYSTEM_MENU | wxTHICK_FRAME
   			#style = wxDEFAULT_DIALOG_STYLE
		)

		sizer = wxBoxSizer(wxVERTICAL)

		label = wxStaticText(
			win, -1, "Read with Spatial Sound\n(e.g., Try 1 or 2)")
		sizer.Add(label, 0, wxALIGN_CENTRE|wxALL, 5)

		box = wxBoxSizer(wxHORIZONTAL)

		label = wxStaticText(win, -1, "Num Sources:")
		box.Add(label, 0, wxALIGN_CENTRE|wxALL, 5)

		numSourcesText = wxTextCtrl(win, -1, "1", size=(80,-1))
		box.Add(numSourcesText, 1, wxALIGN_CENTRE|wxALL, 5)

		sizer.AddSizer(box, 0, wxGROW|wxALIGN_CENTER_VERTICAL|wxALL, 5)
		
		box = wxBoxSizer(wxHORIZONTAL)

		btn = wxButton(win, wxID_OK, " OK ")
		btn.SetDefault()
		box.Add(btn, 0, wxALIGN_CENTRE|wxALL, 5)

		btn = wxButton(win, wxID_CANCEL, " Cancel ")
		box.Add(btn, 0, wxALIGN_CENTRE|wxALL, 5)

		sizer.AddSizer(box, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5)

		win.SetSizer(sizer)
		win.SetAutoLayout(true)
		sizer.Fit(win)

		val = win.ShowModal()
		if val == wxID_OK:
			numSources = int(numSourcesText.GetValue())
			if (numSources < 1):
				print '** Error: Num sources must be positive'
			else:
				listIn = self.GetDisplayTextAsWordList()
				doShiftPos = 1
				listIn2 = removeItemsFromList(
					tokenizeLines(listIn), [' ', ''])
				
				win.Destroy() #destroying the pop up box influence
				speakMultipleStreams(listIn2, numSources, doShiftPos) # <--?????
	

	def OnClickReadWithSpatialOrientation (self, e):
		listIn = self.GetDisplayTextAsWordList()
		doShiftPos = 1
		listIn2 = removeItemsFromList(
				tokenizeLines(listIn), [' ', ''])
		speakSpatialOrientation(listIn2, 1, 1)
		
			
	def OnClickRestoreOriginal(self,e):
	    if (self.ttw3d.getTXTFile() != ''):
	    	self.DisplayTXTFile()
	
	# *** BUG: WHEN SET AS CALLBACK, WILL NOT COMPILE (SEE __init__) ***    	
	def OnTypeCharIntoDisplay(self):
		print '** OnTypeCharIntoDisplay' # DEBUG
		self.isFileLoaded = 0
	    	
	def DisplayTXTFile(self):
		""" Display the current TXT file to be read. """
		self.SetDisplayText(file(self.ttw3d.getTXTFile()).readlines())
			
	def GetDisplayText(self):
		""" Get the array of text strings currently displayed in the window, 
			as lines. """
		text = []
		for i in range(self.control.GetNumberOfLines()):
			text.append(self.control.GetLineText(i) + '\n') # or '\r'
		return text
		
	def GetDisplayTextAsWordList(self):
		""" Get the array of text strings currently displayed in the window, 
			as individual words. """
		return tokenizeLines(self.GetDisplayText())
		
	def SetDisplayText(self, textIn):
		""" Display the array textIn in the window. """
		#print textIn
		self.control.Clear()
		for i in range(len(textIn)):
			self.control.AppendText(textIn[i])
	    
	def SpeakDisplayText(self):
		""" Read the array of text strings currently displayed in the window. """
		text = self.GetDisplayText()
		for i in range(len(text)):
			self.ttw3d.Speak(text[i], tts_async)

	def onClickSlow(self,e):
		self.ttw3d.SetRate(-5)

	def onClickNormal(self,e):
		self.ttw3d.SetRate(0)

	def onClickMedium(self,e):
		self.ttw3d.SetRate(5)

	def onClickFast(self,e):
		self.ttw3d.SetRate(10)
		
if __name__ == '__main__':
	
	app = wxPySimpleApp()
	frame = MainWindow(None, -1, "Document Skimmer")
	#frame.Show(1)
	app.MainLoop()
