/*
 *  stateMachine.h
 *  Roomba
 *
 *  Created by Glenn Elliott on 9/7/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef STATEMACHINE_H
#define STATEMACHINE_H

#include <memory>

#include "pthread++.h"

#include "states.h"

class Timer: public Thread
{
public:
    Timer();
    
    void start(int32_t milliseconds);
    
    void stop();
    
protected:
    void entry();
    
private:
    Mutex mTimerMutex;
    Condition mTimerCondition;
    
    int32_t mCurrentDelay;
};

class StateMachine
{
public:
    static StateMachine* instance();
    
public:
    void setInitialState(State* initialState);
    
    void go();
    void stop();
    
    void terminate();

    void setTimeout(int32_t milliseconds);
    void setWallUpperThreshold(int32_t upper);
    void setWallLowerThreshold(int32_t lower);
    
    void signalTimeout();

protected:
    StateMachine();
    
private:
    void _stateChange(State* newState, bool redo = false);
    
private:
    int32_t mWallUpper, mWallLower;
    
    bool mTerminate;
    
    Mutex mEventLoopMutex;
    Condition mEventLoopCondition;
    
    std::auto_ptr<State> mCurrentState;
    
    Timer mTimer;
    bool mRaisedTimeout;
    
    static std::auto_ptr<StateMachine> mInstance;
};



#endif
