/*
 *  states.h
 *  Roomba
 *
 *  Created by Glenn Elliott on 9/7/08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef STATES_H
#define STATES_H

#include <string>

class State
{
public:
    State(): mOk(true) {}
    virtual ~State() {}
    
    virtual State* onEnter() { return(this); }
    virtual void   onExit() {  }
    
    virtual State* onTimeout() { return(this); }
    virtual State* onBump(int bumperState) { return(this); }
    virtual State* onWallOverThreshold(int wallSignalStrength) { return(this); }
    virtual State* onWallUnderThreshold(int wallSignalStrength) { return(this); }
    
    virtual State* onIR(int irState) { return(this); }
    
    virtual State* onCharging() { return(this); }
    
    bool isOk() { return(mOk); }

protected:
    static const int16_t MAX_SPEED = 250;
    
protected:
    bool mOk;
};




class Initial: public State
{
public:
    Initial(const std::string& serialPort);
    
    State* onEnter();
    
private:
    std::string mSerialPort;
};


class Shutdown: public State
{
public:
    Shutdown():
        State()
    {
    }
    
    State* onEnter();
};


class RandomWalk: public State
{
public:
    RandomWalk():
        State(),
        mWaggling(false)
    {
    }
    
    State* onEnter();
    State* onTimeout();
    State* onBump(int bumperState);
    
    State* onWallOverThreshold(int wallSignalStrength);
    State* onIR(int irState);
    
    State* onCharging();
    
private:
    void _waggle(int16_t speed);
    void _stopWaggle();
    
    bool mWaggling;
    bool mWaggleDirection;
    
    static const int16_t WAGGLE_ARC   = 400;
};


class WallFollow: public State
{
public:
    WallFollow(int16_t initialWallStrength):
        State(),
        mInitialWallStrength(initialWallStrength)
    {
    }
    
    State* onEnter();
    State* onTimeout();
    State* onBump(int bumperState);
    
    State* onWallOverThreshold(int wallSignalStrength);
    State* onWallUnderThreshold(int wallSignalStrength);
    
    State* onIR(int irState);
    
    State* onCharging();

private:
    
    int16_t _maximizeWallSensor(int16_t currentStrength, int16_t increment = 20);
    
public:
    int16_t mInitialWallStrength;
    bool mLost;
    int16_t mLastWallSignal;
    
    static const int32_t LOSTWALL_TIMEOUT = 4000; // 4 seconds.
    static const int16_t UPPER_THESH   = 25;
    static const int16_t LOWER_THESH   = 4;
    static const int16_t WALLFOLLOW_ARC = -1200;
};


class Dock: public State
{
public:
    Dock(int initialIR):
        State(),
        mInitialIR(initialIR)
    {
    }
    
    State* onEnter();
    State* onTimeout();
    State* onBump(int bumperState);
    
    State* onIR(int irState);
    
    State* onCharging();
    
    static bool isBaseStation(int16_t ir);
    
    enum eIR
    {
        FORCE_FIELD = 242,  // 0xF2
        GREEN = 244,        // 0xF4
        GREEN_FF = 246,     // 0xF6
        RED = 248,          // 0xF8
        RED_FF = 250,       // 0xFA
        RED_GREEN = 252,    // 0xFC
        RGFF = 254          // 0xFE
    };
    
private:
    int16_t _maximizeIRSensor(int16_t currentIR, int16_t increment = 30);
    int16_t _countIRs(int16_t ir);
    float   _rank(int16_t ir);
    
public:
    int16_t mInitialIR;
    int16_t mLastIR;
    
    bool mDocking;
    
    static const int16_t DOCKING_SPEED = 250;
    static const int16_t DOCKING_TIME_LIMIT = 45;
};

#endif












