#takes in a key file and a ciphertext file
#outputs a plaintext string

import sys
import os

#check for the right number of parameters
if len(sys.argv) != 3:
    print("wrong number of parameters\n")
    sys.exit()

keyFileName = str(sys.argv[1])
ctFileName = str(sys.argv[2])

keyFile = open(keyFileName, "r")
ctFile = open(ctFileName, "r")

key = bytes.fromhex(keyFile.read())
ct = bytes.fromhex(ctFile.read())

keyFile.close()
ctFile.close()

msgLen = len(ct)
if msgLen > len(key):
    print("key too short!")
    sys.exit()

#produce the ciphertext!
msg = bytearray()

#TODO: complete the decryption

print(msg.decode())


