#generates a key pair for signing
#takes two file names to write the secret key and verification key to as parameters (in that order)
#but has a default if the parameters are not provided

import sys
from cryptography.hazmat.primitives import serialization
from cryptography.hazmat.primitives.asymmetric.ed25519 import Ed25519PrivateKey

skFileName = "sk.key"
vkFileName = "vk.key"

#update default if param is provided
if len(sys.argv) == 3:
    skFileName = str(sys.argv[1])
    vkFileName = str(sys.argv[2])

sk = Ed25519PrivateKey.generate()
vk = sk.public_key()

skFile = open(skFileName, "w")
vkFile = open(vkFileName, "w")
skFile.write(sk.private_bytes(serialization.Encoding.Raw,serialization.PrivateFormat.Raw,serialization.NoEncryption()).hex())
vkFile.write(vk.public_bytes(serialization.Encoding.Raw,serialization.PublicFormat.Raw).hex())
skFile.close()
vkFile.close()

