import csv
import numpy as np
import matplotlib
matplotlib.use('Agg')
import matplotlib.pyplot as plt

nmins = ['12', '24', '48']
Tmins = ['3.0', '10.0', '50.0']
Lmins = ['1.0', '5.0']
#ps = ['0.10', '0.25', '0.50']
ps = ['0.50']
#numLs = ['3', '6', '12']
numLs = ['1', '2', '3']
fs = 28

def read_schedulability(file_path):
    array1, array2 = [], []
    with open(file_path, mode='r') as file:
        csv_reader = csv.reader(file)
        for idx, row in enumerate(csv_reader):
            if idx == 0:
                #array1 = row
                array1 = list(map(float,row))
            elif idx == 1:
                array2 = list(map(float,row))
            else:
                break
    return array1, array2

for nmin in nmins:
    for Tmin in Tmins:
        for Lmin in Lmins:
            for p in ps:
                for numL in numLs:
                    prefix = nmin + '_' + Tmin + '_' + Lmin + '_' + p + '_' + numL
                    filename_njlp = prefix + '_result-NJLP.csv'
                    filename_fmlp = prefix + '_result-FMLP.csv'

                    xs, y1s = read_schedulability(filename_njlp)
                    xs2, y2s = read_schedulability(filename_fmlp)
                    print(y1s)
                    print(y2s)

                    plt.figure()
                    plt.plot(xs, y1s, marker='o', label='NJLP')
                    plt.plot(xs2, y2s, marker='x', label='FMLP')

                    plt.xlabel('normalized utilization', fontsize = fs)
                    plt.ylabel('schedulability', fontsize = fs)
                    plt.xticks(fontsize=fs)
                    plt.yticks(fontsize=fs)
                    plt.ylim(0,1)
                    plt.legend(fontsize=fs, loc='upper right')
                    fig= plt.gcf()
                    fig.set_size_inches(16, 4)
                    plt.savefig(prefix + '_plot.pdf', bbox_inches='tight')
                    plt.close()
                    print('saving plot: ' + prefix + '_plot.pdf')
