#include <stdio.h>
#include <stdlib.h>

#include <iostream>
#include <cstdlib>
#include <cstring>
#include <thread>
#include <utility>
#include <string>
#include <vector>
#include <random>
#include <ctime>
#include <fstream>
#include <sstream>
#include <algorithm>
#include <queue>

#include "task_gen.hpp"

#define Utests {0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9}
#define processors 6
//#define ntests {10,20,30,40,50,60,70,80,90,100}
#define ntests {pair<int,int>(std::max(2*m,10),25), pair<int,int>(std::max(4*m,10),50), pair<int,int>(std::max(8*m,10),100)}
#define Titests {pair<double,double>(3,33),pair<double,double>(10,100),pair<double,double>(50,500)}
//#define numResources {(int)(m/2),(int)m,(int)(2*m)}
#define numResources {1,2,3}
//#define ptests {0.1,0.25,0.5}
#define ptests {0.5}
//#define NiqSample pair<int,int>(1,5)
#define NiqSample pair<int,int>(1,2)
#define LikSamples {pair<double,double>(1,100),pair<double,double>(5,1280)}
#define Tg 0.1
#define numtasksets 1000

using std::thread;
using std::pair;
using std::string;
using std::vector;
using std::priority_queue;

std::default_random_engine gen;

class taskUtilComp {
public:
	int operator() (task*& t1, task*& t2) {
		return t1->ui < t2->ui;
	}
};

// This let's us iterate through a priority queue
template <class T, class S, class C>
S& PQContainer(priority_queue<T, S, C>& q);

void trim(std::string &s);
double Harmonic(int k);

int main( int argc, char* argv[] ) {
	if( argc < 4 ) {
		printf("usage: %s folder csvfilenamepartial whichbi\n", argv[0]);
		printf("\t where the partial name is 10_partialname\n");
		printf("\t where whichbi is 0 or 1, 0= FMLP, 1=NJLP\n");
		printf("\t e.g. ../X_EDZL_stats.csv would be: %s ../ EDZL_stats.csv 0\n", argv[0]);
		return 1;
	}

	int whichbi = atoi( argv[3] );

	if( whichbi < 0 || whichbi > 1 ) {
		printf("whichbi can only be 0 or 1, 0= FMLP, 1=NJLP\n");
		return 1;
	}

	// Need overheads for CXS, LOCK, RELEASE, SCHED, UNLOCK
	double CXS[10];
	double LOCK[10];
	double RELEASE[10];
	double SCHED[10];
	double UNLOCK[10];

	// Read in the csv data
	{
		memset( CXS, 0, sizeof(CXS) );
		memset( LOCK, 0, sizeof(LOCK) );
		memset( RELEASE, 0, sizeof(RELEASE) );
		memset( SCHED, 0, sizeof(SCHED) );
		memset( UNLOCK, 0, sizeof(UNLOCK) );

		for( int ni = 0; ni < 10; ++ni ) {
			int n = (ni+1)*10;

			char fname[250];
			sprintf(fname,"%s%d_%s",argv[1],n,argv[2]);
			std::fstream fin;
			fin.open(fname, std::ios::in);
			if( fin.fail() ) {
				printf("invalid csv file name: %s\n", fname);
				return 1;
			}
			vector<vector<string>> rows;
			string temp;

			while(fin.peek() != EOF) {
				vector<string> csvrow;
				string line, word;
				std::getline(fin,line);
				std::stringstream s(line);

				while(std::getline(s,word,',')) {
					trim(word);
					csvrow.push_back(word);
				}
				rows.push_back(csvrow);
			}
			fin.close();

			for( int i = 1; i < rows.size(); ++i ) {
				printf("%d: Max overhead for %s is %s\n", n, rows[i][2].c_str(), rows[i][7].c_str() );
				if( !strcmp(rows[i][2].c_str(), "CXS") )
					CXS[ni] = atof( rows[i][7].c_str() );
				else if( !strcmp(rows[i][2].c_str(), "LOCK") )
					LOCK[ni] = atof( rows[i][7].c_str() );
				else if( !strcmp(rows[i][2].c_str(), "RELEASE") )
					RELEASE[ni] = atof( rows[i][7].c_str() );
				else if( !strcmp(rows[i][2].c_str(), "SCHED") )
					SCHED[ni] = atof( rows[i][7].c_str() );
				else if( !strcmp(rows[i][2].c_str(), "UNLOCK") )
					UNLOCK[ni] = atof( rows[i][7].c_str() );
			}

			if( CXS[ni] == 0 ) printf("Warning, missing CXS for n=%d\n", n);
			if( LOCK[ni] == 0 ) printf("Warning, missing LOCK for n=%d\n", n);
			if( RELEASE[ni] == 0 ) printf("Warning, missing RELEASE for n=%d\n", n);
			if( SCHED[ni] == 0 ) printf("Warning, missing SCHED for n=%d\n", n);
			if( UNLOCK[ni] == 0 ) printf("Warning, missing UNLOCK for n=%d\n", n);

			// Apply a non-decreasing correction
			if( ni > 0 ) {
				if( CXS[ni] < CXS[ni-1] ) CXS[ni] = CXS[ni-1];
				if( LOCK[ni] < LOCK[ni-1] ) LOCK[ni] = LOCK[ni-1];
				if( RELEASE[ni] < RELEASE[ni-1] ) RELEASE[ni] = RELEASE[ni-1];
				if( SCHED[ni] < SCHED[ni-1] ) SCHED[ni] = SCHED[ni-1];
				if( UNLOCK[ni] < UNLOCK[ni-1] ) UNLOCK[ni] = UNLOCK[ni-1];
			}
		}
	}

	//srand(time(nullptr));
	//gen.seed((unsigned int)time(nullptr));
	srand(1234);
	gen.seed(1234);

	//unsigned long tgen_seed = time(nullptr);
	//unsigned long tgen_seed_step = time(nullptr);
	unsigned long tgen_seed = 1234;
	unsigned long tgen_seed_step = 1234;
	
	vector<double> Uset = Utests;
    int m = processors;
    vector<pair<int,int>> nsets = ntests;
	vector<pair<double,double>> Tiset = Titests;
	vector<double> pset = ptests;
	const auto Niqset = NiqSample;
	const vector<pair<double,double>> Liktests = LikSamples;

	FILE* logfile = fopen("log.csv","w");
	fprintf(logfile,"U,m,TiMin,TiMax,LlMin,LlMax,p,numresources,n,tasksetidx,sched\n");

	// For each value of m
	for( auto nset : nsets ) {
		printf("-=-=- n range (%d,%d)\n", nset.first, nset.second);
		// q is defined with m
		vector<int> qset = numResources;

		// For each Ti range (short, medium, long)
		for( auto& Tirange : Tiset ) {
			printf("-=-=- Ti range (%f,%f)\n", Tirange.first, Tirange.second);

			// For each value of p
			for( auto p : pset ) {
				printf("-=-=- p=%f\n", p);

				// For each number of resources
				for( auto q : qset ) {
					printf("-=-=- numResources=%d\n", q);

					for( auto& Lik : Liktests ) {

						FILE* resultfile;
						{
							char rfname[260];
							sprintf(rfname,"%d_%.1f_%.1f_%.2f_%d_result-%s.csv",nset.first,Tirange.first,Lik.first,p,q,whichbi == 0 ? "FMLP" : "NJLP");
							resultfile = fopen(rfname,"w");
							if( !resultfile ) {
								printf("Could not open result file %s for writing!\n", rfname);
								return 1;
							}
							
							for( int i = 0; i < Uset.size(); ++i ) {
								if( i ) fprintf(resultfile,",");
								fprintf(resultfile,"%.1f",Uset[i]);
							}
							fprintf(resultfile,"\n");
						}

						// For each utilization
						//for( auto U : Uset ) {
						for( int Uidx = 0; Uidx < Uset.size(); ++Uidx ) {
							auto U = Uset[Uidx];
							printf("-=-=- U=%f\n", U);

							int numPass = 0;

							// generate this many task sets
							for( int tsindex = 0; tsindex < numtasksets; ++tsindex ) {
								// Pick a value for n
								int n = rand() % (nset.second - nset.first) + nset.first;

								/*if( ( rand() % 100 ) == 0 ) {
									printf("n: %d\n", n);
									std::cin.get();
								}*/
								//printf("-=-=- n=%d\n", n);

								// For this value of n, we need to linear interp and find our overhead values
								// n is between 10 and 100, where 10 is the 0th, and 100 is the 9th index
								double CXS_n, RELEASE_n, SCHED_n; //, UNLOCK_n, LOCK_n;
								{
									int niprev = (n / 10)-1;
									int ninext = niprev + 1;
									int nmod = n % 10;
									CXS_n = ( CXS[niprev] + ( nmod * (CXS[ninext] - CXS[niprev]) ) ) / (2200 * 1000);
									//LOCK_n = ( LOCK[niprev] + ( nmod * (LOCK[ninext] - LOCK[niprev]) ) ) / (2200 * 1000);
									RELEASE_n = ( RELEASE[niprev] + ( nmod * (RELEASE[ninext] - RELEASE[niprev]) ) ) / (2200 * 1000);
									SCHED_n = ( SCHED[niprev] + ( nmod * (SCHED[ninext] - SCHED[niprev]) ) ) / (2200 * 1000);
									//UNLOCK_n = ( UNLOCK[niprev] + ( nmod * (UNLOCK[ninext] - UNLOCK[niprev]) ) ) / (2200 * 1000);

									//printf("CXS, LOCK, RELEASE, SCHED, UNLOCK for n=%d is: %f %f %f %f %f\n", n, CXS_n, LOCK_n, RELEASE_n, SCHED_n, UNLOCK_n);
								}

								printf("Task Set %d/%d\r", tsindex, numtasksets);

								int* nAccessQ = nullptr;
								double* LmaxQ = nullptr; // this is L_l in the work

								if( q ) {
									nAccessQ = (int*)calloc(q,sizeof(int));
									LmaxQ = (double*)calloc(q,sizeof(double));

									std::uniform_real_distribution<double> Llsampler(Lik.first,Lik.second);

									for( int i = 0; i < q; ++i )
										LmaxQ[i] = Llsampler(gen) / 1000;
								}

								// Generate task set
								vector<task*> taskset;
								{
									TaskGen tgen(m,Tirange.first,Tirange.second,n,U,Tg,tgen_seed);
									tgen.outputTaskSet(&taskset);
									tgen_seed += tgen_seed_step;
								}

								// Will a task issue a request?
								{
									std::uniform_real_distribution<double> u01(0,1);

									for( auto& t : taskset ) {
										if( t->requests.empty() )
											t->requests.clear();

										// For each resource, is this task selected?
										//double totalLi = 0;
										for( int i = 0; i < q; ++i ) {
											if( u01(gen) < p ) {
												// Selected to access resource q
												nAccessQ[i]++;
												int Niq = ( rand() % (Niqset.second - Niqset.first) ) + Niqset.first;
												t->requests.push_back( request { i, Niq } );
												//totalLi += LmaxQ[i];
											}
										} // for each resource
									} // for each task
								} // end adding requests to tasks

								for( int i = 0; i < q; ++i )
									nAccessQ[i] = n;

								// RECOMPUTE
								double UNLOCK_n[q];
								double LOCK_n[q];
								for( int i = 0; i < q; ++i ) {
									int niprev = (nAccessQ[i] / 10)-1;
									int ninext = niprev + 1;
									int nmod = nAccessQ[i] % 10;
									UNLOCK_n[i] = ( UNLOCK[niprev] + ( nmod * (UNLOCK[ninext] - UNLOCK[niprev]) ) ) / (2200 * 1000);
									LOCK_n[i] = ( LOCK[niprev] + ( nmod * (LOCK[ninext] - LOCK[niprev]) ) ) / (2200 * 1000);
								}

								for( int i = 0; i < q; ++i )
									LmaxQ[i] += UNLOCK_n[i]; // * nAccessQ[i];

								char schedable = '0';

								// Now do Ci inflations
								for(auto& t : taskset) {
									double inflation = 0;
									inflation = RELEASE_n + SCHED_n	+ CXS_n;
									
									double bi = 0;
									double infl_fmlp;
									double infl_njlp;
									for( auto& r : t->requests ) {
										bi += LOCK_n[r.resourceId] * r.requestcount;
										infl_fmlp = r.requestcount * nAccessQ[ r.resourceId ] * LmaxQ[ r.resourceId ];
										infl_njlp = r.requestcount * ( ( (3*m) - 1 + ( m * std::max(Harmonic(nAccessQ[ r.resourceId ]) - Harmonic(m), 0.) ) ) * LmaxQ[ r.resourceId ] );
										
										if( whichbi == 0 )// FMLP
											bi += infl_fmlp;
										else if( whichbi == 1 ) // NJLP
											bi += infl_njlp;
										
										//if( rand() % 100 ) {
										//	printf("FMLP vs NJLP: %f %f - %f %d\n", infl_fmlp, infl_njlp, ( ( (3*m) - 1 + ( m * std::max(Harmonic(nAccessQ[ r.resourceId ]) - Harmonic(m), 0.) ) ) ), nAccessQ[ r.resourceId ] );
										//	std::cin.get();
										//}
									}
									inflation += bi;

									
									t->costinflated = t->cost + inflation;

									if( t->costinflated > t->period ) {
										/*printf("Overinflation Ci Ci_inflated Ti= %.2f %.4f %.2f\n", t->cost, t->costinflated, t->period);
										printf("overheads: RELEASE+SCHED+CXS = %f + %f + %f = %f\n", RELEASE_n, SCHED_n, CXS_n, RELEASE_n + SCHED_n + CXS_n);
										for( auto& r : t->requests ) {
											printf("Resource %d accessed %d times:\n", r.resourceId, r.requestcount);
											printf("LOCK_n: %d*%f = %f\n", r.requestcount, LOCK_n, r.requestcount * LOCK_n );
											if( whichbi == 0 )
												printf("bi: %d*%f = %f\n", r.requestcount, LmaxQ[r.resourceId], r.requestcount * LmaxQ[ r.resourceId ]);
											else if( whichbi == 1 )
												printf("bi: %d*%f = %f\n", 0, 0., 0. ); // TODO
										}
										std::cin.get();*/
										schedable = 'B';
									}

									t->ui = t->costinflated / t->period;
								}

								// EVERYTHING IS SET, now do the actual schedulability test.
								// If this flag is set, then a cost exceeds the period after overheads.
								if( schedable == '0' ) {
									// First sort out the tasks by their utilization
									priority_queue<task*,vector<task*>,taskUtilComp> minutilpq;
									double sumutil = 0;
									for( auto& t : taskset ) {
										minutilpq.push(t);
										sumutil += t->ui;
									}
									auto& pqVec = PQContainer(minutilpq);

									schedable = 'F';
									// If any of these pass, then it is schedulable
									for( int mp = 1; mp <= m; ++mp ) {
										// T1 must contain the tasks with the largest delta_i
										// Find the max
										double maxui_T1 = 0;
										for( int i = 0; i < minutilpq.size() - (m - mp); ++i ) {
											if( pqVec[i]->ui > maxui_T1 )
												maxui_T1 = pqVec[i]->ui;
										}

										// THE TEST!
										if( sumutil <= mp - ( (mp - 1) * maxui_T1 ) ) {
											schedable = 'T';
											++numPass;
											break;
										}
									}
								}

								//fprintf("U,m,n,Tmin,Tmax,p,numresources,tasksetidx,sched\n");
								/*fprintf(logfile,"%f,%d,%d,%f,%f,%f,%d,%d,%c\n",
									U, m, n, Tirange.first, Tirange.second, p, q, tsindex, schedable
									);*/
								//fprintf(logfile,"U,m,TiMin,TiMax,LlMin,LlMax,p,numresources,n,tasksetidx,sched\n");
								fprintf(logfile,"%f,%d,%f,%f,%f,%f,%f,%d,%d,%d,%c\n",
									U, m, Tirange.first, Tirange.second, Lik.first, Lik.second, p, q, n, tsindex, schedable
									);
								fflush(logfile);

								for(int i = 0; i < taskset.size(); ++i )
									delete taskset[i];
								taskset.clear();

								if( q ) {
									delete[] nAccessQ;
									delete[] LmaxQ;
								}
							} // task set

							if( Uidx ) fprintf(resultfile,",");
							fprintf(resultfile,"%f", (double)numPass / (double)numtasksets );
						} // util

						fclose(resultfile);
					} // Likranges
				} // qset
			} // pset
		} // Tirange
	} // mset

	fclose(logfile);
	
	return 0;
}

double Harmonic(int k) {
	double total = 0;
	for( int i = 1; i <= k; ++i )
		total += 1. / i;
	return total;
}

inline void ltrim(std::string &s);
inline void rtrim(std::string &s);

// trim from both ends (in place)
void trim(std::string &s) {
    rtrim(s);
    ltrim(s);
}

// trim from start (in place)
inline void ltrim(std::string &s) {
    s.erase(s.begin(), std::find_if(s.begin(), s.end(), [](unsigned char ch) {
        return !std::isspace(ch);
    }));
}

// trim from end (in place)
inline void rtrim(std::string &s) {
    s.erase(std::find_if(s.rbegin(), s.rend(), [](unsigned char ch) {
        return !std::isspace(ch);
    }).base(), s.end());
}

// This let's us iterate through a priority queue
template <class T, class S, class C>
S& PQContainer(priority_queue<T, S, C>& q) {
	struct HackedQueue : private priority_queue<T, S, C> {
		static S& Container(priority_queue<T, S, C>& q) {
			return q.* & HackedQueue::c;
		}
	};
	return HackedQueue::Container(q);
}
